package com.xebialabs.xldeploy.provisioner.resolver.placeholder

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary
import com.xebialabs.xldeploy.provisioner._

import scala.collection.convert.wrapAll._

abstract class PlaceholderResolver {

  def resolve(value: AnyRef, pd: Option[PropertyKind] = None): AnyRef = pd match {
    case Some(PropertyKind.STRING) | None =>
      scanPlaceholdersAndReplace(value.toString)
    case Some(PropertyKind.LIST_OF_STRING) =>
      new JArrayList[String](value.asInstanceOf[JList[String]].map(x => scanPlaceholdersAndReplace(x)))
    case Some(PropertyKind.SET_OF_STRING) =>
      new JHashSet[String](value.asInstanceOf[JSet[String]].map(x => scanPlaceholdersAndReplace(x)))
    case Some(PropertyKind.MAP_STRING_STRING) =>
      new JHashMap[String, String](value.asInstanceOf[JMap[String, String]].map { case (k, v) => scanPlaceholdersAndReplace(k) -> scanPlaceholdersAndReplace(v) })
    case _ =>
      value
  }

  def scanPlaceholdersAndReplace(propertyValue: String, delimiters: String = defaultDelimiter): String
}

object PlaceholderResolver {

  def apply(dictionary: ConsolidatedDictionary, sourceDeployed: Option[ProvisionedType] = None): MustachePlaceholderResolver = {
    new MustachePlaceholderResolver(dictionary, sourceDeployed)
  }
}
