
package com.xebialabs.xldeploy.provisioner
package api

import java.util.Calendar
import javax.jcr.Node
import javax.jcr.nodetype.NodeType

import com.xebialabs.deployit.jcr.JcrConstants._
import com.xebialabs.deployit.repository.internal.Root
import com.xebialabs.deployit.server.api.repository.RawRepository
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import scala.collection.convert.wrapAll._

@Component
class ProvisioningRepositoryInitialization extends RepositoryInitialization with Logging {

  val rootType = "internal." + classOf[Root].getSimpleName

  override def doInitialize(repository: RawRepository): Unit = {
    logger.info("Initializing repository")
    createIfMissing("Blueprints", repository)
    createIfMissing("ProvisioningEnvironments", repository)
    createIfMissing("Providers", repository)
  }

  override def getComponent: String = "xld-provision-roots"

  private def createIfMissing(rootName: String, repository: RawRepository): Unit = {
    val availableRootNames = repository.findNodesByType(typeOf(rootType)).toList.map(_.getName)
    if (!availableRootNames.contains(rootName)) {
      createXlRoot(rootName, repository)
    }
  }

  private[this] def createXlRoot(rootName: String, repository: RawRepository) = {
    val node: Node = repository.create(rootName)
    node.addMixin(CONFIGURATION_ITEM_NODETYPE_NAME)
    node.addMixin(NodeType.MIX_VERSIONABLE)
    node.setProperty(CONFIGURATION_ITEM_TYPE_PROPERTY_NAME, rootType)
    node.setProperty(LAST_MODIFIED_AT_PROPERTY_NAME, Calendar.getInstance)
    logger.debug(s"Configured XL Root node $rootName at $node")
  }
}

