package com.xebialabs.xldeploy.provisioner.steps

import com.xebialabs.deployit.plugin.api.deployment.specification.Operation
import com.xebialabs.deployit.plugin.api.rules.{Scope, StepPostConstructContext}
import com.xebialabs.deployit.repository.{RepositoryService, RepositoryServiceHolder}
import com.xebialabs.xldeploy.provisioner._

import scala.collection.convert.wrapAll._

trait ProvisionedItemsStep extends BaseStep with ScopeValidator {

  private[steps] var provisionedBlueprint: ProvisionedBlueprint = null
  private[steps] var provisioneds: Set[ProvisionedType] = _
  private[steps] var provisioningPackage: ProvisioningPackage = _
  private[steps] var blueprint: Blueprint = _
  private[steps] var provisioningEnvironment: ProvisioningEnvironment = _

  def validScope: Scope

  private[steps] def validate(ctx: StepPostConstructContext) {
    if (!correctDeployedApplication(ctx).isInstanceOf[ProvisionedBlueprint]) {
      throw new IllegalArgumentException(s"This step can be applied to provisioned blueprint only")
    }
    validateScope(ctx.getScope, validScope)
  }

  private[steps] def correctDeployedApplication(ctx: StepPostConstructContext) = {
    if(ctx.getSpecification.getOperation == Operation.DESTROY) {
      ctx.getSpecification.getPreviousAppliedDistribution
    } else {
      ctx.getSpecification.getAppliedDistribution
    }
  }

  private[steps] def setParameters(ctx: StepPostConstructContext): Unit = {
    provisionedBlueprint = correctDeployedApplication(ctx).asInstanceOf[ProvisionedBlueprint]
    provisioningPackage = provisionedBlueprint.getProvisioningPackage
    provisioneds = provisionedBlueprint.getDeployeds.map(_.asInstanceOf[ProvisionedType]).toSet
    provisioningEnvironment = provisionedBlueprint.getProvisioningEnvironment
    blueprint = provisioningPackage.blueprint
  }

  protected def repositoryService: RepositoryService = {
    RepositoryServiceHolder.getRepositoryService
  }
}
