/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.provisioner.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath$;
import com.xebialabs.deployit.engine.tasker.PreviewStepAdapter;
import com.xebialabs.deployit.engine.tasker.StepBlock;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;
import com.xebialabs.deployit.plugin.api.xld.DistributionVersion;
import com.xebialabs.deployit.plugin.api.xld.Domain;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.xldeploy.provisioner.DeprovisioningRequest;
import com.xebialabs.xldeploy.provisioner.Provision;
import com.xebialabs.xldeploy.provisioner.Provision$;
import com.xebialabs.xldeploy.provisioner.ProvisionedBlueprint;
import com.xebialabs.xldeploy.provisioner.ProvisionedBlueprintAware;
import com.xebialabs.xldeploy.provisioner.ProvisioningEnvironment;
import com.xebialabs.xldeploy.provisioner.ProvisioningPackage;
import com.xebialabs.xldeploy.provisioner.ProvisioningRequest;
import com.xebialabs.xldeploy.provisioner.ProvisioningTask;
import com.xebialabs.xldeploy.provisioner.ProvisioningTask$;
import com.xebialabs.xldeploy.provisioner.SelectedProvision;
import com.xebialabs.xldeploy.provisioner.StepPreview;
import com.xebialabs.xldeploy.provisioner.StepPreview$;
import com.xebialabs.xldeploy.provisioner.TaskPreview;
import com.xebialabs.xldeploy.provisioner.TaskPreview$;
import com.xebialabs.xldeploy.provisioner.Template;
import com.xebialabs.xldeploy.provisioner.ValidationError;
import com.xebialabs.xldeploy.provisioner.api.CiReferencesSupport;
import com.xebialabs.xldeploy.provisioner.api.CiReferencesSupport$;
import com.xebialabs.xldeploy.provisioner.api.ProvisioningService;
import com.xebialabs.xldeploy.provisioner.api.ProvisioningService$;
import com.xebialabs.xldeploy.provisioner.api.ValidationSupport$;
import com.xebialabs.xldeploy.provisioner.api.package;
import com.xebialabs.xldeploy.provisioner.api.package$;
import com.xebialabs.xldeploy.provisioner.api.package$Implicits$EditProvisionedBlueprint$;
import com.xebialabs.xldeploy.provisioner.api.package$Implicits$EditProvisioningEnvironment$;
import com.xebialabs.xldeploy.provisioner.api.package$Implicits$ReadProvisioningPackage$;
import com.xebialabs.xldeploy.provisioner.api.package$ProvisionedBlueprintUtils$;
import com.xebialabs.xldeploy.provisioner.api.package$ToOptionUtil$;
import com.xebialabs.xldeploy.provisioner.resolver.TemplateResolver$;
import com.xebialabs.xldeploy.provisioner.resolver.placeholder.MissingTemplatePlaceholderCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsScala;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Success;

public abstract class ProvisioningService$class {
    public static Provision initialProvisioning(ProvisioningService $this, ProvisioningRequest provisioning) {
        $this.info((Function0)new Serializable($this, provisioning){
            public static final long serialVersionUID = 0L;
            private final ProvisioningRequest provisioning$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial provisioning of ", " onto ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.provisioning$1.packageId(), this.provisioning$1.provisioningEnvironmentId()}));
            }
            {
                this.provisioning$1 = provisioning$1;
            }
        });
        ProvisioningPackage provisioningPackage = (ProvisioningPackage)ProvisioningService$class.checkPermission($this, $this.repositoryService().read(provisioning.packageId()), ClassTag$.MODULE$.apply(ProvisioningPackage.class), package$Implicits$ReadProvisioningPackage$.MODULE$);
        ProvisioningEnvironment cloudEnvironment = (ProvisioningEnvironment)ProvisioningService$class.checkPermission($this, $this.repositoryService().read(provisioning.provisioningEnvironmentId()), ClassTag$.MODULE$.apply(ProvisioningEnvironment.class), package$Implicits$EditProvisioningEnvironment$.MODULE$);
        HashSet missingPlaceholdersAggregator = new HashSet();
        ProvisionedBlueprint provisionedBlueprint = ProvisioningService$class.createProvisionedBlueprint($this, provisioning, provisioningPackage, cloudEnvironment, missingPlaceholdersAggregator);
        ProvisioningService$class.findMissingPlaceholdersInProvisioneds($this, provisionedBlueprint, provisioning.somePlaceholders(), provisioningPackage, cloudEnvironment, missingPlaceholdersAggregator);
        return (Provision)ProvisioningService$class.provisionedBlueprintWithMissingPlaceholder($this, provisionedBlueprint, missingPlaceholdersAggregator).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Provision apply(ProvisionedBlueprint pb) {
                return new Provision(pb, Provision$.MODULE$.apply$default$2(), Provision$.MODULE$.apply$default$3());
            }
        }).getOrElse((Function0)new Serializable($this, provisionedBlueprint){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvisioningService $outer;
            private final ProvisionedBlueprint provisionedBlueprint$1;

            public final Provision apply() {
                return ProvisioningService$class.com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$validateProvision(this.$outer, new Provision(this.provisionedBlueprint$1, Provision$.MODULE$.apply$default$2(), Provision$.MODULE$.apply$default$3()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.provisionedBlueprint$1 = provisionedBlueprint$1;
            }
        });
    }

    private static boolean findMissingPlaceholdersInProvisioneds(ProvisioningService $this, ProvisionedBlueprint provisionedBlueprint, scala.collection.immutable.Map userProvidedPlaceholders, ProvisioningPackage provisioningPackage, ProvisioningEnvironment provisioningEnvironment, HashSet missingPlaceholdersAggregator) {
        Dictionaries dic = ProvisioningService$class.dictionaries($this, (Seq)((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaBuffer(provisioningEnvironment.getDictionaries()), (scala.collection.immutable.Map)userProvidedPlaceholders.filterNot((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String value = (String)tuple2._2();
                    boolean bl = value.isEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        return missingPlaceholdersAggregator.addAll($this.deployedService().generateSelectedDeployeds((AppliedDistribution)provisionedBlueprint, scala.collection.convert.package$.MODULE$.wrapAll().seqAsJavaList((Seq)((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaSet(provisioningPackage.getDeployables()).toList()), provisioningEnvironment.getMembers(), dic).getUnresolvedPlaceholders());
    }

    public static ProvisioningTask createProvisioningTask(ProvisioningService $this, Provision provision) {
        ProvisioningTask provisioningTask;
        $this.info((Function0)new Serializable($this, provision){
            public static final long serialVersionUID = 0L;
            private final Provision provision$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating provisioning task for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.provision$2.provisionedBlueprint().getId()}));
            }
            {
                this.provision$2 = provision$2;
            }
        });
        WorkDir workDir = $this.workDirFactory().newWorkDir();
        Provision validatedProvision = ProvisioningService$class.com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$validateProvision($this, ProvisioningService$class.resolve($this, provision, workDir));
        if (validatedProvision.validationErrors().isDefined()) {
            Option x$7 = validatedProvision.validationErrors();
            Option x$8 = ProvisioningTask$.MODULE$.apply$default$1();
            provisioningTask = new ProvisioningTask(x$8, x$7);
        } else {
            provisioningTask = new ProvisioningTask(Option$.MODULE$.apply((Object)ProvisioningService$class.createAndRegisterInitialTask($this, provision, workDir)), ProvisioningTask$.MODULE$.apply$default$2());
        }
        return provisioningTask;
    }

    public static Provision validate(ProvisioningService $this, Provision provision) {
        $this.info((Function0)new Serializable($this, provision){
            public static final long serialVersionUID = 0L;
            private final Provision provision$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validate of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.provision$3.provisionedBlueprint().getId()}));
            }
            {
                this.provision$3 = provision$3;
            }
        });
        WorkDir workDir = $this.workDirFactory().newWorkDir();
        return ProvisioningService$class.com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$validateProvision($this, ProvisioningService$class.resolve($this, provision, workDir));
    }

    public static ProvisioningTask deprovision(ProvisioningService $this, DeprovisioningRequest deprovisioningRequest) {
        $this.info((Function0)new Serializable($this, deprovisioningRequest){
            public static final long serialVersionUID = 0L;
            private final DeprovisioningRequest deprovisioningRequest$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"De-provisioning of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deprovisioningRequest$1.provisionedBlueprintId()}));
            }
            {
                this.deprovisioningRequest$1 = deprovisioningRequest$1;
            }
        });
        WorkDir workDir = $this.workDirFactory().newWorkDir();
        ProvisionedBlueprint provisionedBlueprint = (ProvisionedBlueprint)ProvisioningService$class.checkPermission($this, $this.repositoryService().read(deprovisioningRequest.provisionedBlueprintId()), ClassTag$.MODULE$.apply(ProvisionedBlueprint.class), package$Implicits$EditProvisionedBlueprint$.MODULE$);
        return ProvisioningService$class.createDeprovisionSpecification($this, provisionedBlueprint, workDir);
    }

    public static TaskPreview preview(ProvisioningService $this, Provision provision) {
        TaskPreview taskPreview;
        $this.info((Function0)new Serializable($this, provision){
            public static final long serialVersionUID = 0L;
            private final Provision provision$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preview of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.provision$4.provisionedBlueprint().getId()}));
            }
            {
                this.provision$4 = provision$4;
            }
        });
        WorkDir workDir = $this.workDirFactory().newWorkDir();
        Provision validated2 = ProvisioningService$class.com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$validateProvision($this, provision);
        Option someValidationErrors = validated2.validationErrors();
        if (someValidationErrors.isDefined()) {
            Option x$9 = someValidationErrors;
            Option x$10 = TaskPreview$.MODULE$.apply$default$1();
            taskPreview = new TaskPreview(x$10, x$9);
        } else {
            TaskSpecification taskSpec = ProvisioningService$class.createTaskSpecification($this, provision, workDir);
            taskPreview = new TaskPreview((Option)new Some((Object)new TaskPreviewBlock(provision.provisionedBlueprint().getId(), (BlockState)taskSpec.getBlock())), TaskPreview$.MODULE$.apply$default$2());
        }
        return taskPreview;
    }

    public static StepPreview preview(ProvisioningService $this, Provision provision, String blockId, int stepNr) {
        StepPreview stepPreview;
        TaskPreview taskPreview = $this.preview(provision);
        Option option = taskPreview.preview();
        if (option instanceof Some) {
            StepPreview stepPreview2;
            Some some;
            Block child;
            Some some2 = (Some)option;
            TaskPreviewBlock p = (TaskPreviewBlock)some2.x();
            Block topBlock = (Block)p.getBlock();
            Option childBlock = topBlock.getBlock(BlockPath$.MODULE$.apply(blockId).tail());
            Option option2 = childBlock;
            if (option2 instanceof Some && (child = (Block)(some = (Some)option2).x()) instanceof StepBlock) {
                StepPreview stepPreview3;
                StepBlock stepBlock = (StepBlock)child;
                java.util.List steps = stepBlock.getSteps();
                if (stepNr > 0 && stepNr <= ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaBuffer(steps).length()) {
                    StepState stepState = (StepState)steps.get(stepNr - 1);
                    stepPreview3 = ProvisioningService$class.hasPermission($this, DeployitPermissions.TASK_PREVIEWSTEP) ? new StepPreview((Option)new Some((Object)new PreviewStepAdapter((TaskStep)stepState)), StepPreview$.MODULE$.apply$default$2()) : new StepPreview((Option)new Some((Object)stepState), StepPreview$.MODULE$.apply$default$2());
                } else {
                    Some x$11 = new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationError[]{new ValidationError("", (Option)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a valid step number [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stepNr)})))})));
                    Option x$12 = StepPreview$.MODULE$.apply$default$1();
                    stepPreview3 = new StepPreview(x$12, (Option)x$11);
                }
                stepPreview2 = stepPreview3;
            } else {
                Some x$13 = new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationError[]{new ValidationError("", (Option)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block [", "}] is a composite block so it has no steps"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blockId})))})));
                Option x$14 = StepPreview$.MODULE$.apply$default$1();
                stepPreview2 = new StepPreview(x$14, (Option)x$13);
            }
            stepPreview = stepPreview2;
        } else {
            Option x$15 = taskPreview.validationErrors();
            Option x$16 = StepPreview$.MODULE$.apply$default$1();
            stepPreview = new StepPreview(x$16, x$15);
        }
        return stepPreview;
    }

    public static Provision generateAllProvisioneds(ProvisioningService $this, Provision provision) {
        HashSet missingPlaceholdersAggregator = new HashSet();
        ProvisionedBlueprint provisionedBlueprint = provision.provisionedBlueprint();
        ProvisioningPackage provisioningPackage = (ProvisioningPackage)ProvisioningService$class.checkPermission($this, $this.repositoryService().read(provisionedBlueprint.getVersion().getId()), ClassTag$.MODULE$.apply(ProvisioningPackage.class), package$Implicits$ReadProvisioningPackage$.MODULE$);
        ProvisioningEnvironment provisioningEnvironment = (ProvisioningEnvironment)ProvisioningService$class.checkPermission($this, $this.repositoryService().read(provisionedBlueprint.getProvisioningEnvironment().getId()), ClassTag$.MODULE$.apply(ProvisioningEnvironment.class), package$Implicits$EditProvisioningEnvironment$.MODULE$);
        Seq allProvisionableIds = ((SetLike)((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaSet(provisioningPackage.getDeployables()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Deployable x$1) {
                return x$1.getId();
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq();
        Seq provisioneds = ProvisioningService$class.generateProvisioneds($this, provisionedBlueprint, allProvisionableIds, provisioningPackage, provisioningEnvironment, ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).mapAsScalaMap(provisionedBlueprint.getUnresolvedPlaceholders()).toMap(Predef$.MODULE$.$conforms()), missingPlaceholdersAggregator);
        Option maybeEnvironment = ProvisioningService$class.createProvisionedEnvironment($this, provisioningEnvironment, provisionedBlueprint, missingPlaceholdersAggregator);
        return (Provision)ProvisioningService$class.provisionedBlueprintWithMissingPlaceholder($this, provisionedBlueprint, missingPlaceholdersAggregator).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Provision apply(ProvisionedBlueprint bp) {
                return new Provision(bp, Provision$.MODULE$.apply$default$2(), Provision$.MODULE$.apply$default$3());
            }
        }).getOrElse((Function0)new Serializable($this, provisionedBlueprint, provisioneds, maybeEnvironment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvisioningService $outer;
            private final ProvisionedBlueprint provisionedBlueprint$2;
            private final Seq provisioneds$1;
            private final Option maybeEnvironment$1;

            public final Provision apply() {
                return ProvisioningService$class.com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$validateProvision(this.$outer, new Provision(package$ProvisionedBlueprintUtils$.MODULE$.withEnvironment$extension(package$.MODULE$.ProvisionedBlueprintUtils(this.provisionedBlueprint$2), (Option<Environment>)this.maybeEnvironment$1), package$ToOptionUtil$.MODULE$.toOption$extension(package$.MODULE$.ToOptionUtil(this.provisioneds$1)), Provision$.MODULE$.apply$default$3()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.provisionedBlueprint$2 = provisionedBlueprint$2;
                this.provisioneds$1 = provisioneds$1;
                this.maybeEnvironment$1 = maybeEnvironment$1;
            }
        });
    }

    public static Provision generateSelectedProvisioneds(ProvisioningService $this, SelectedProvision selectedProvision) {
        HashSet missingPlaceholdersAggregator = new HashSet();
        List provisionableIds = selectedProvision.selectedProvisionableIds();
        Provision provision = selectedProvision.provision();
        ProvisionedBlueprint provisionedBlueprint = provision.provisionedBlueprint();
        ProvisioningPackage provisioningPackage = (ProvisioningPackage)ProvisioningService$class.checkPermission($this, $this.repositoryService().read(provisionedBlueprint.getVersion().getId()), ClassTag$.MODULE$.apply(ProvisioningPackage.class), package$Implicits$ReadProvisioningPackage$.MODULE$);
        ProvisioningEnvironment provisioningEnvironment = (ProvisioningEnvironment)ProvisioningService$class.checkPermission($this, $this.repositoryService().read(provisionedBlueprint.getProvisioningEnvironment().getId()), ClassTag$.MODULE$.apply(ProvisioningEnvironment.class), package$Implicits$EditProvisioningEnvironment$.MODULE$);
        Seq provisioneds = ProvisioningService$class.generateProvisioneds($this, provisionedBlueprint, (Seq)provisionableIds, provisioningPackage, provisioningEnvironment, ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).mapAsScalaMap(provisionedBlueprint.getUnresolvedPlaceholders()).toMap(Predef$.MODULE$.$conforms()), missingPlaceholdersAggregator);
        Option maybeEnvironment = ProvisioningService$class.createProvisionedEnvironment($this, provisioningEnvironment, provisionedBlueprint, missingPlaceholdersAggregator);
        return (Provision)ProvisioningService$class.provisionedBlueprintWithMissingPlaceholder($this, provisionedBlueprint, missingPlaceholdersAggregator).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Provision apply(ProvisionedBlueprint bp) {
                return new Provision(bp, Provision$.MODULE$.apply$default$2(), Provision$.MODULE$.apply$default$3());
            }
        }).getOrElse((Function0)new Serializable($this, provision, provisionedBlueprint, provisioneds, maybeEnvironment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvisioningService $outer;
            private final Provision provision$1;
            private final ProvisionedBlueprint provisionedBlueprint$3;
            private final Seq provisioneds$2;
            private final Option maybeEnvironment$2;

            public final Provision apply() {
                return ProvisioningService$class.com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$validateProvision(this.$outer, new Provision(package$ProvisionedBlueprintUtils$.MODULE$.withEnvironment$extension(package$.MODULE$.ProvisionedBlueprintUtils(this.provisionedBlueprint$3), (Option<Environment>)this.maybeEnvironment$2), package$ToOptionUtil$.MODULE$.toOption$extension(package$.MODULE$.ToOptionUtil((Traversable)this.provisioneds$2.$plus$plus((GenTraversableOnce)this.provision$1.provisioneds().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nil$ apply() {
                        return Nil$.MODULE$;
                    }
                }), Seq$.MODULE$.canBuildFrom()))), Provision$.MODULE$.apply$default$3()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.provision$1 = provision$1;
                this.provisionedBlueprint$3 = provisionedBlueprint$3;
                this.provisioneds$2 = provisioneds$2;
                this.maybeEnvironment$2 = maybeEnvironment$2;
            }
        });
    }

    private static Seq generateProvisioneds(ProvisioningService $this, ProvisionedBlueprint provisionedBlueprint, Seq ids, ProvisioningPackage provisioningPackage, ProvisioningEnvironment provisioningEnvironment, scala.collection.immutable.Map unresolvedPlaceholders, Set missingPlaceholdersAggregator) {
        scala.collection.immutable.Map provisionablePerId = ((TraversableOnce)((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaSet(provisioningPackage.getDeployables()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Deployable> apply(Deployable d) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.getId()), (Object)d);
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq requiredProvisionables = (Seq)ids.map((Function1)new Serializable($this, provisioningPackage, provisionablePerId){
            public static final long serialVersionUID = 0L;
            public final ProvisioningPackage provisioningPackage$1;
            private final scala.collection.immutable.Map provisionablePerId$1;

            public final Deployable apply(String id) {
                return (Deployable)this.provisionablePerId$1.getOrElse((Object)id, (Function0)new Serializable(this, id){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProvisioningService$.anonfun.4 $outer;
                    private final String id$1;

                    public final Nothing$ apply() {
                        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not found in provisioning package ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1, this.$outer.provisioningPackage$1.getId()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.id$1 = id$1;
                    }
                });
            }
            {
                this.provisioningPackage$1 = provisioningPackage$1;
                this.provisionablePerId$1 = provisionablePerId$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Dictionaries dic = Dictionaries.of((java.util.List)provisioningEnvironment.getDictionaries()).withAdditionalEntries(scala.collection.convert.package$.MODULE$.wrapAll().mapAsJavaMap((Map)unresolvedPlaceholders));
        GeneratedDeployeds generatedDeployeds = $this.deployedService().generateSelectedDeployeds((AppliedDistribution)provisionedBlueprint, scala.collection.convert.package$.MODULE$.wrapAll().seqAsJavaList(requiredProvisionables), provisioningEnvironment.getMembers(), dic);
        missingPlaceholdersAggregator.addAll(generatedDeployeds.getUnresolvedPlaceholders());
        return ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaBuffer(generatedDeployeds.getDeployeds());
    }

    private static Option provisionedBlueprintWithMissingPlaceholder(ProvisioningService $this, ProvisionedBlueprint provisionedBlueprint, HashSet missingPlaceholdersAggregator) {
        None$ none$;
        if (missingPlaceholdersAggregator.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            HashMap userProvidedPlaceholders = new HashMap();
            userProvidedPlaceholders.putAll(provisionedBlueprint.getUnresolvedPlaceholders());
            ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaSet((Set)missingPlaceholdersAggregator).map((Function1)new Serializable($this, userProvidedPlaceholders){
                public static final long serialVersionUID = 0L;
                private final java.util.Map userProvidedPlaceholders$1;

                public final String apply(String placeholder) {
                    return this.userProvidedPlaceholders$1.put(placeholder, "");
                }
                {
                    this.userProvidedPlaceholders$1 = userProvidedPlaceholders$1;
                }
            }, Set$.MODULE$.canBuildFrom());
            provisionedBlueprint.setUnresolvedPlaceholders(userProvidedPlaceholders);
            none$ = Option$.MODULE$.apply((Object)provisionedBlueprint);
        }
        return none$;
    }

    private static ProvisionedBlueprint createProvisionedBlueprint(ProvisioningService $this, ProvisioningRequest provisioning, ProvisioningPackage provisioningPackage, ProvisioningEnvironment provisioningEnvironment, Set missingPlaceholdersAggregator) {
        ConsolidatedDictionary consolidatedDictionary = ProvisioningService$class.dictionaries($this, (Seq)((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaBuffer(provisioningEnvironment.getDictionaries()), provisioning.somePlaceholders()).consolidate();
        ProvisioningService$class.addMissingTemplatePlaceholders($this, provisioningPackage, consolidatedDictionary, missingPlaceholdersAggregator);
        ProvisionedBlueprint provisionedBlueprint = (ProvisionedBlueprint)$this.deployedService().generateDeployedApplication(Type.valueOf(ProvisionedBlueprint.class), (DistributionVersion)provisioningPackage, (Domain)provisioningEnvironment, missingPlaceholdersAggregator, scala.collection.convert.package$.MODULE$.wrapAll().mapAsJavaMap((Map)provisioning.somePlaceholders()));
        String provisioningId = package$.MODULE$.hashId(provisionedBlueprint.getName());
        provisionedBlueprint.setId(IdGenerator.generateId((ConfigurationItem)provisioningEnvironment, (String)new StringBuilder().append((Object)provisioningId).append((Object)"-").append((Object)provisioningPackage.getDistribution().getName()).toString()));
        provisionedBlueprint.setProvisioningId(provisioningId);
        provisionedBlueprint.setUnresolvedPlaceholders(scala.collection.convert.package$.MODULE$.wrapAll().mapAsJavaMap((Map)provisioning.somePlaceholders()));
        return provisionedBlueprint;
    }

    private static void addMissingTemplatePlaceholders(ProvisioningService $this, ProvisioningPackage provisioningPackage, ConsolidatedDictionary consolidatedDictionary, Set missingPlaceholdersAggregator) {
        MissingTemplatePlaceholderCollector missingPlaceholderCollector = new MissingTemplatePlaceholderCollector(consolidatedDictionary);
        ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaSet(provisioningPackage.boundTemplates()).foreach((Function1)new Serializable($this, missingPlaceholdersAggregator, missingPlaceholderCollector){
            public static final long serialVersionUID = 0L;
            private final Set missingPlaceholdersAggregator$1;
            private final MissingTemplatePlaceholderCollector missingPlaceholderCollector$1;

            public final boolean apply(Template t) {
                return this.missingPlaceholdersAggregator$1.addAll(scala.collection.convert.package$.MODULE$.wrapAll().setAsJavaSet(this.missingPlaceholderCollector$1.missingPlaceholders(t)));
            }
            {
                this.missingPlaceholdersAggregator$1 = missingPlaceholdersAggregator$1;
                this.missingPlaceholderCollector$1 = missingPlaceholderCollector$1;
            }
        });
    }

    private static Option createProvisionedEnvironment(ProvisioningService $this, ProvisioningEnvironment provisioningEnvironment, ProvisionedBlueprint provisionedBlueprint, Set missingPlaceholdersAggregator) {
        None$ none$;
        if (provisionedBlueprint.getEnvironmentName() == null) {
            none$ = None$.MODULE$;
        } else {
            Dictionaries dic = Dictionaries.of((java.util.List)provisioningEnvironment.getDictionaries()).withAdditionalEntries(provisionedBlueprint.getUnresolvedPlaceholdersWithValues());
            none$ = (Option)TemplateResolver$.MODULE$.apply(dic.consolidate(), provisionedBlueprint).resolveEnvironmentId().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Environment apply(String id) {
                    return (Environment)com.xebialabs.xldeploy.provisioner.package$.MODULE$.createCi(id, ClassTag$.MODULE$.apply(Environment.class));
                }
            }).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Option<Environment> apply(Environment x) {
                    return Option$.MODULE$.apply((Object)x);
                }
            }).recoverWith((PartialFunction)new Serializable($this, missingPlaceholdersAggregator){
                public static final long serialVersionUID = 0L;
                private final Set missingPlaceholdersAggregator$2;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof DictionaryValueException) {
                        DictionaryValueException dictionaryValueException = (DictionaryValueException)A1;
                        this.missingPlaceholdersAggregator$2.addAll(dictionaryValueException.getMissingValues());
                        object = new Success((Object)None$.MODULE$);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof DictionaryValueException;
                    return bl;
                }
                {
                    this.missingPlaceholdersAggregator$2 = missingPlaceholdersAggregator$2;
                }
            }).get();
        }
        return none$;
    }

    private static Provision resolve(ProvisioningService $this, Provision provision, WorkDir workDir) {
        Option resolvedProvisioned = provision.provisioneds().map((Function1)new Serializable($this, workDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvisioningService $outer;
            public final WorkDir workDir$1;

            public final Seq<ConfigurationItem> apply(Seq<ConfigurationItem> x$2) {
                return (Seq)x$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProvisioningService$.anonfun.5 $outer;

                    public final ConfigurationItem apply(ConfigurationItem x$3) {
                        CiReferencesSupport.ReferenceResolver<ConfigurationItem> qual$1 = CiReferencesSupport$.MODULE$.ReferenceResolver(x$3);
                        RepositoryService x$17 = this.$outer.com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$anonfun$$$outer().repositoryService();
                        WorkDir x$18 = this.$outer.workDir$1;
                        scala.collection.mutable.Map<String, ConfigurationItem> x$19 = qual$1.resolved$default$3();
                        return qual$1.resolved(x$17, x$18, x$19);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ ProvisioningService com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.workDir$1 = workDir$1;
            }
        });
        CiReferencesSupport.ReferenceResolver<ProvisionedBlueprint> qual$2 = CiReferencesSupport$.MODULE$.ReferenceResolver(provision.provisionedBlueprint());
        RepositoryService x$20 = $this.repositoryService();
        WorkDir x$21 = workDir;
        scala.collection.mutable.Map<String, ConfigurationItem> x$22 = qual$2.resolved$default$3();
        ProvisionedBlueprint resolvedProvisionedBlueprint = qual$2.resolved(x$20, x$21, x$22);
        Option x$23 = resolvedProvisioned;
        ProvisionedBlueprint x$24 = resolvedProvisionedBlueprint;
        Option x$25 = provision.copy$default$3();
        return provision.copy(x$24, x$23, x$25);
    }

    public static Provision com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$validateProvision(ProvisioningService $this, Provision provision) {
        Option<Traversable> x$26 = package$ToOptionUtil$.MODULE$.toOption$extension(package$.MODULE$.ToOptionUtil((Traversable)((TraversableLike)provision.provisioneds().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvisioningService $outer;

            public final Seq<ValidationError> apply(Seq<ConfigurationItem> x$4) {
                return ValidationSupport$.MODULE$.CiSeqValidationUtils(x$4).validated(this.$outer.validator());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        })).$plus$plus((GenTraversableOnce)ProvisioningService$class.validateBlueprintAware($this, (ProvisionedBlueprintAware)provision), Seq$.MODULE$.canBuildFrom())));
        ProvisionedBlueprint x$27 = provision.copy$default$1();
        Option x$28 = provision.copy$default$2();
        return provision.copy(x$27, x$28, x$26);
    }

    private static Seq validateBlueprintAware(ProvisioningService $this, ProvisionedBlueprintAware aware) {
        return ValidationSupport$.MODULE$.CiValidationUtils((ConfigurationItem)aware.provisionedBlueprint()).validateWithoutProperty("provisioneds", $this.validator());
    }

    private static String createAndRegisterInitialTask(ProvisioningService $this, Provision provision, WorkDir workDir) {
        TaskSpecification taskSpecification = ProvisioningService$class.createTaskSpecification($this, provision, workDir);
        return $this.taskEngine().register(taskSpecification);
    }

    private static TaskSpecification createTaskSpecification(ProvisioningService $this, Provision provision, WorkDir workDir) {
        ProvisioningService$class.checkPermission($this, $this.repositoryService().read(provision.provisionedBlueprint().getProvisioningPackage().getId()), ClassTag$.MODULE$.apply(ProvisioningPackage.class), package$Implicits$ReadProvisioningPackage$.MODULE$);
        ProvisioningService$class.checkPermission($this, $this.repositoryService().read(provision.provisionedBlueprint().getProvisioningEnvironment().getId()), ClassTag$.MODULE$.apply(ProvisioningEnvironment.class), package$Implicits$EditProvisioningEnvironment$.MODULE$);
        MultiDeltaSpecification deltaSpec = $this.deploymentService().prepareInitialSpecification(ProvisioningService$class.createInitialDeployment($this, provision, workDir), scala.collection.convert.package$.MODULE$.wrapAll().mapAsJavaMap((Map)Predef$.MODULE$.Map().empty()));
        return $this.deploymentService().getTaskFullSpecification(deltaSpec, workDir, new WorkDir[]{workDir});
    }

    /*
     * WARNING - void declaration
     */
    private static Deployment createInitialDeployment(ProvisioningService $this, Provision provision, WorkDir workDir) {
        void var3_3;
        Deployment deployment = new Deployment();
        Option maybeConfigurationItems = provision.provisioneds().map((Function1)new Serializable($this, workDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvisioningService $outer;
            public final WorkDir workDir$2;

            public final Seq<ConfigurationItem> apply(Seq<ConfigurationItem> x$5) {
                return (Seq)x$5.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProvisioningService$.anonfun.8 $outer;

                    public final ConfigurationItem apply(ConfigurationItem x$6) {
                        CiReferencesSupport.ReferenceResolver<ConfigurationItem> qual$3 = CiReferencesSupport$.MODULE$.ReferenceResolver(x$6);
                        RepositoryService x$29 = this.$outer.com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$anonfun$$$outer().repositoryService();
                        WorkDir x$30 = this.$outer.workDir$2;
                        scala.collection.mutable.Map<String, ConfigurationItem> x$31 = qual$3.resolved$default$3();
                        return qual$3.resolved(x$29, x$30, x$31);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ ProvisioningService com$xebialabs$xldeploy$provisioner$api$ProvisioningService$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.workDir$2 = workDir$2;
            }
        });
        deployment.setDeployeds(new ArrayList(scala.collection.convert.package$.MODULE$.wrapAll().seqAsJavaList((Seq)maybeConfigurationItems.getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        }))));
        CiReferencesSupport.ReferenceResolver<ProvisionedBlueprint> qual$4 = CiReferencesSupport$.MODULE$.ReferenceResolver(provision.provisionedBlueprint());
        RepositoryService x$32 = $this.repositoryService();
        WorkDir x$33 = workDir;
        scala.collection.mutable.Map<String, ConfigurationItem> x$34 = qual$4.resolved$default$3();
        deployment.setDeployedApplication((ConfigurationItem)qual$4.resolved(x$32, x$33, x$34));
        deployment.setId(new StringBuilder().append((Object)"deployment-").append((Object)UUID.randomUUID().toString()).toString());
        deployment.setDeploymentType(Deployment.DeploymentType.INITIAL);
        return var3_3;
    }

    private static ProvisioningTask createDeprovisionSpecification(ProvisioningService $this, ProvisionedBlueprint provisionedBlueprint, WorkDir workDir) {
        MultiDeltaSpecification deltaSpec = $this.deploymentService().prepareUndeployment((AppliedDistribution)provisionedBlueprint);
        TaskSpecification taskSpecification = $this.deploymentService().getTaskFullSpecification(deltaSpec, workDir, new WorkDir[0]);
        String taskId = $this.taskEngine().register(taskSpecification);
        return new ProvisioningTask(Option$.MODULE$.apply((Object)taskId), ProvisioningTask$.MODULE$.apply$default$2());
    }

    private static Dictionaries dictionaries(ProvisioningService $this, Seq dictionaries, scala.collection.immutable.Map userProvidedPlaceholders) {
        return Dictionaries.of((java.util.List)scala.collection.convert.package$.MODULE$.wrapAll().seqAsJavaList(dictionaries)).withAdditionalEntries(scala.collection.convert.package$.MODULE$.wrapAll().mapAsJavaMap((Map)userProvidedPlaceholders));
    }

    private static ConfigurationItem checkPermission(ProvisioningService $this, ConfigurationItem ci, ClassTag evidence$1, package.PermissionChecker evidence$2) {
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly((Object)evidence$1)).runtimeClass();
        package.PermissionChecker permissionChecker = (package.PermissionChecker)Predef$.MODULE$.implicitly((Object)evidence$2);
        Checks.checkArgument((boolean)clazz.isAssignableFrom(ci.getClass()), (String)"%s is not a %s", (Object[])new Object[]{ci, clazz.getSimpleName()});
        ConfigurationItem typedCi = ci;
        permissionChecker.checkPermission(typedCi);
        return typedCi;
    }

    private static boolean hasPermission(ProvisioningService $this, Permission permission) {
        return permission.getPermissionHandler().hasPermission(null);
    }

    public static void $init$(ProvisioningService $this) {
    }
}

