package com.xebialabs.xldeploy.provisioner

import com.xebialabs.deployit.plugin.api.deployment.specification.{DeltaSpecification, Operation}

package object orchestrator {

  def performing(operation: Operation): String = operation match {
    case Operation.CREATE => "Provisioning"
    case Operation.DESTROY => "Tearing down"
    case Operation.MODIFY => "Updating"
    case Operation.NOOP => "Not updating"
  }

  def descriptionBasedOnSpec(spec: DeltaSpecification) = {
    val provisioningPackage = spec.getAppliedDistribution.getVersion
    val blueprint = provisioningPackage.getDistribution
    val provisioningEnvironment = spec.getAppliedDistribution.getEnvironment
    s"${performing(spec.getOperation)} ${blueprint.getName} ${provisioningPackage.getName} on Provisioning Environment ${provisioningEnvironment.getName}"
  }
}
