package com.xebialabs.xldeploy.provisioner.api

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage
import com.xebialabs.deployit.service.validation.Validator
import com.xebialabs.xldeploy.provisioner.ValidationError

import collection.convert.wrapAll._

object ValidationSupport {

  implicit class CiValidationUtils(ci: ConfigurationItem) {
    def validateWithoutProperty(propertyName: String)(implicit validator: Validator): Seq[ValidationError] = {
      validated.filterNot(_.propertyName.exists(_ == propertyName))
    }

    def validated(implicit validator: Validator): Seq[ValidationError] = {
      validator.validate(ci).flatMap(createValidationMessages)
    }
  }

  implicit class CiSeqValidationUtils(cis: Seq[ConfigurationItem]) {
    def validated(implicit validator: Validator): Seq[ValidationError] = {
      cis.flatMap(_.validated)
    }
  }

  private def createValidationMessages(msg: ValidationMessage): Option[ValidationError] = {
    if (msg.getLevel == ValidationMessage.Level.ERROR) {
      Option(ValidationError(msg.getCiId, Option(msg.getPropertyName), msg.getMessage))
    } else {
      None
    }
  }

}
