package com.xebialabs.xldeploy.provisioner.host

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.overthere.Host
import com.xebialabs.overthere.{OperatingSystemFamily, OverthereConnection}
import com.xebialabs.xldeploy.provisioner.resolver.TemplateResolver
import com.xebialabs.xldeploy.provisioner.{ProvisionedBlueprint, ProvisionedType, Template}

@Metadata(virtual = true, description = "Machine that runs middleware, on which scripts can be executed, etc.")
class LazyHost extends Host {

  private var hostTemplate: Template = _
  private var sourceProvisioned: ProvisionedType = _
  private var provisionedBlueprint: ProvisionedBlueprint = _

  @transient
  private lazy val templateResolver = TemplateResolver(provisionedBlueprint)

  override def getConnection: OverthereConnection = host.getConnection

  private lazy val host: Host = {
    templateResolver.resolveSingleRootTemplate(hostTemplate, sourceProvisioned).configurationItem.get.asInstanceOf[Host]
  }

  override def getOs: OperatingSystemFamily = OperatingSystemFamily.valueOf(templateResolver.resolveValue(hostTemplate.getProperty[String]("os")))

  override def getTemporaryDirectoryPath: String = host.getTemporaryDirectoryPath

  override def getStagingDirectoryPath: String = null

  def setHostTemplate(hostTemplate: Template): Unit = this.hostTemplate = hostTemplate

  def setProvisionedBlueprint(provisionedBlueprint: ProvisionedBlueprint): Unit = this.provisionedBlueprint = provisionedBlueprint

  def setSourceProvisioned(sourceProvisioned: ProvisionedType): Unit = this.sourceProvisioned = sourceProvisioned

}
