package com.xebialabs.xldeploy.provisioner
package orchestrator

import com.xebialabs.deployit.engine.spi.orchestration.{InterleavedOrchestration, Orchestration, Orchestrations, Orchestrator}
import com.xebialabs.deployit.plugin.api.deployment.specification.{DeltaSpecification, Operation}
import com.xebialabs.xlplatform._

import scala.collection.convert.wrapAll._

trait ProvisionOrchestrator extends Orchestrator with ProvisionOnly {

  override def orchestrate(specification: DeltaSpecification): Orchestration = {
    checkContainsProvisionedBlueprint(specification)
    val byProvisioneds = specification.getDeltas.groupBy(_.correctDeployed)
    val plan = byProvisioneds.map {
      case (provisioned, deltas) =>
        Orchestrations.interleaved(descriptionBasedOnProvisioned(provisioned, specification.getOperation), deltas: _*)
    }
    compositeOrchestrator(descriptionBasedOnSpec(specification), plan.toSeq)
  }

  private def descriptionBasedOnProvisioned(provisioned: DeployedType, operation: Operation): String = {
    s"${performing(operation)} ${provisioned.getName}"
  }

  def compositeOrchestrator(description: String, plan: Seq[InterleavedOrchestration]): Orchestration

}

@Orchestrator.Metadata(name = "sequential-by-provisioned")
class SequentialByProvisionedOrchestrator extends ProvisionOrchestrator {
  override def compositeOrchestrator(description: String, plan: Seq[InterleavedOrchestration]): Orchestration =
    Orchestrations.serial(description, plan: _*)
}

@Orchestrator.Metadata(name = "parallel-by-provisioned")
class ParallelByProvisioned extends ProvisionOrchestrator {
  override def compositeOrchestrator(description: String, plan: Seq[InterleavedOrchestration]): Orchestration =
    Orchestrations.parallel(description, plan: _*)
}
