package com.xebialabs.xldeploy.provisioner
package resolver.placeholder

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.deployit.service.replacement.{ConsolidatedDictionary, DictionaryValueException, MustachePlaceholderScanner}

import scala.collection.convert.wrapAll._
import scala.util.Try

class MissingTemplatePlaceholderCollector(consolidatedDictionary: ConsolidatedDictionary) {

  private val stringPropertyTypes = Seq(PropertyKind.STRING, PropertyKind.SET_OF_STRING, PropertyKind.MAP_STRING_STRING, PropertyKind.LIST_OF_STRING)

  val scanner = new MustachePlaceholderScanner()

  def missingPlaceholders(template: Template): Set[String] = {
    var missingPlaceholders = Set[String]()
    template.getType.getDescriptor.getPropertyDescriptors
      .filter(pd => stringPropertyTypes.contains(pd.getKind))
      .foreach(pd => {
        val propertyValue = template.getProperty[Any](pd.getName)
        if (propertyValue.nonEmpty) {
          Try(consolidatedDictionary.resolve(propertyValue, pd)).recover {
            case e: DictionaryValueException => missingPlaceholders = missingPlaceholders ++ e.getMissingValues
          }
        }
      })
    missingPlaceholders
  }

}
