package com.xebialabs.xldeploy.provisioner.resolver.placeholder

import com.samskivert.mustache.Mustache
import com.xebialabs.deployit.service.replacement.{ConsolidatedDictionary, MustachePlaceholderScanner}
import com.xebialabs.xldeploy.provisioner._
import org.slf4j.LoggerFactory

import scala.collection.convert.wrapAll._

private[resolver] class MustachePlaceholderResolver(dictionary: ConsolidatedDictionary, sourceDeployed: Option[ProvisionedType]) extends PlaceholderResolver with PlaceholderEncloser{

  val logger = LoggerFactory.getLogger(getClass)

  val scanner = new MustachePlaceholderScanner()

  override def scanPlaceholdersAndReplace(propertyValue: String, delimiters: String) = try {
    val map: JMap[String, String] = scanner.scan(propertyValue).map(placeholder => placeholder -> fetchValue(placeholder)).toMap[String, String]
    Mustache.compiler().compile(propertyValue).execute(map)
  } catch {
    case e: Exception => throw new IllegalArgumentException(s"Placeholder values could not be resolved for input $propertyValue", e)
  }

  private[this] def fetchValue(placeholder: String): String = {
    sourceDeployed match {
      case Some(d) if isEnclosedBy(placeholder, contextDelimiter) => d.getProperty(stripEnclosingDelimiters(placeholder)).toString
      case _ if isEnclosedBy(placeholder, literalDelimiter) => "{{" + stripEnclosingDelimiters(placeholder) + "}}"
      case _ => dictionary.get(placeholder)
    }
  }

}


object MustachePlaceholderResolver {

  def apply(dictionary: ConsolidatedDictionary, sourceDeployed: ProvisionedType): MustachePlaceholderResolver = {
    new MustachePlaceholderResolver(dictionary, Option(sourceDeployed))
  }

}

