package com.xebialabs.xldeploy.provisioner.steps

import com.xebialabs.deployit.service.replacement.Dictionaries
import com.xebialabs.xldeploy.provisioner.{JMap, JList, Dictionary}
import com.xebialabs.xldeploy.provisioner.resolver.placeholder.PlaceholderResolver

object EnvironmentIdResolver {

  def resolveEnvironmentId(envId: String, dictionaries: JList[Dictionary], unresolvedPlaceholders: JMap[String, String]): String = {
    PlaceholderResolver(Dictionaries.of(dictionaries)
      .withAdditionalEntries(unresolvedPlaceholders).consolidate()).resolve(envId).asInstanceOf[String]
  }
}
