<#--

    Copyright (c) 2021. All rights reserved.

    This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.

-->
module "${deployed.name}" {
<#if is_embedded_module>
    source = "./${deployed.source}"
<#else>
    source = "${deployed.source}"
</#if>

<#if deployed.version??>
    version = "${deployed.version}"
</#if>

<#list inputVariables?keys as key>
<#assign value=inputVariables[key]/>
    ${key} = ${value}

</#list>

<#list hcl_variables?keys as key>
    ${key} = ${hcl_variables[key]}
</#list>


<#list secretInputVariables?keys as key>
    ${key} = ${secretInputVariables[key]}
</#list>

}

<#if generate_output_variables>
    <#list outputVariables?keys as key>
output "${deployed.name}-${key}" {
  value = module.${deployed.name}.${outputVariables[key]}
}
    </#list>


    <#list secretOutputVariables?keys as key>
output "${deployed.name}-${key}" {
  value = module.${deployed.name}.${secretOutputVariables[key]}
  sensitive = true
}
    </#list>
</#if>

