#
# Copyright (c) 2021. All rights reserved.
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from terraxld.api import TFE
import glob
import tarfile
import os
from com.xebialabs.overthere.local import LocalFile,LocalConnection

def tar_directory(source_dir):
    archive_file = LocalConnection.getLocalConnection().getTempFile("tfe-xld.tgz")
    print(archive_file)
    print(archive_file.path)

    tar = tarfile.open(archive_file.path, "w:gz")
    for file_name in glob.glob(os.path.join(source_dir, "*")):
        print("  Adding %s..." % file_name)
        tar.add(file_name, os.path.basename(file_name))
    tar.close()
    return archive_file


artifact=deployed.file.path
archive_file = tar_directory(artifact)
print("TGZ:"+archive_file.path)

myapi = TFE(organization)
ws_id = myapi.workspaces.get_id(workspace)
config_version=myapi.config_versions.create(ws_id)

if 'data' not in config_version:
    raise Exception("Cannot create a new config_version. Have you used an Organization API tokens instead of a User or Team token ? Organization API tokens are designed for creating and configuring workspaces and teams. {0}".format(config_version))

cv_id = config_version['data']['id']
print("New configuration version {0}".format(cv_id))

print("upload the tgz")
myapi.config_versions.upload(archive_file.path,cv_id)

context.setAttribute(ws_id + "_cv_id", cv_id)



