from java.io import ByteArrayOutputStream
from java.io import File
from java.io import FileInputStream
from java.io import FileOutputStream
from java.lang import Exception
from java.lang import String
from java.nio.file import Paths
from java.util.zip import ZipEntry
from java.util.zip import ZipOutputStream
from org.apache.commons.io import IOUtils

"""
str_file_path: String - full path to the file including the file name
content: String - the file content as string
"""
def write_to_file(str_file_path, content):
    try:
        new_file = File(str_file_path)
        fos = FileOutputStream(new_file)
        IOUtils.write(content, fos)
    finally:
        IOUtils.closeQuietly(fos)

"""
stream - input stream to the file
close_stream - flag to indicate if the stream should be closed
"""
def get_file_data(stream, close_stream = True):
    try:
        data_as_string = IOUtils.toString(stream, "UTF-8")
        return data_as_string
    finally:
        if close_stream:
            IOUtils.closeQuietly(stream)

"""
file_src_dir: OverthereFile - an instance of OverthereFile referring to a directory
accumulator: Array - accumulator to hold the values in the below Dictionary format
{
    "file_name": file name as string
    "file_path": full file path as string
    "file_content": file content as string
}
"""
def get_files_from_directory(file_src_dir, accumulator):
    try:
        if not should_skip(file_src_dir.getPath()):
            files = file_src_dir.listFiles()
            for file in files:
                if file.isFile():
                    file_name = str(file.getName())
                    file_path = str(file.getPath())
                    entry_as_string = get_file_data(file.getInputStream(), True)
                    file_entry = { "file_name": file_name, "file_path": file_path, "file_content": entry_as_string }
                    accumulator.append(file_entry)
                else:
                    get_files_from_directory(file, accumulator)
    except Exception as e:
        print("Exception occurred while creating file_name/file_content pairs from directory. Reason: {}".format(e.getMessage()))
    return accumulator

"""
file - an instance of File referring to a file
zip_out_stream - the zip output stream
prefix_length - file prefix length
"""
def add_file_to_zip(file, zip_out_stream, prefix_length):
    try:
        zip_entry = ZipEntry(String(file.getPath()).substring(prefix_length))
        zip_out_stream.putNextEntry(zip_entry)
        fis = FileInputStream(file)
        IOUtils.copy(fis, zip_out_stream)
    finally:
        zip_out_stream.closeEntry()
        IOUtils.closeQuietly(fis)

"""
dir - an instance of File referring to a directory
zip_out_stream - the zip output stream
prefix_length - file prefix length
"""
def add_dir_to_zip(dir, zip_out_stream, prefix_length):
    for file in dir.listFiles():
        if file.isFile():
            add_file_to_zip(file, zip_out_stream, prefix_length)
        else:
            add_dir_to_zip(file, zip_out_stream, prefix_length)

"""
dir: OverthereFile - an instance of OverthereFile referring to a directory
"""
def create_zip_from_dir_as_bytes(dir):
    try:
        bos = ByteArrayOutputStream()
        zos = ZipOutputStream(bos)
        add_dir_to_zip(Paths.get(dir.getPath()).toFile(), zos, String(dir.getPath()).length() + 1)
    except Exception as e:
        print("Exception occurred while creating zip file from directory. Reason: {}".format(e.getMessage()))
    finally:
        IOUtils.closeQuietly(zos)
    print("dir {} bytes in file_utils.create_zip_from_dir_as_bytes".format(dir))
    return bos.toByteArray()

"""
s_file_path: String - a string representing the full path of a file/directory
"""
def should_skip(s_file_path):
    return True if s_file_path.find("__MACOSX") != -1 else False