#!/bin/bash

<#assign workingDirectory='${previousDeployed.container.workingDirectory}/${previousDeployed.name}'/>

<#assign destroy_args='-input=false -no-color -force'/>

<#if previousDeployed.parallelism??>
    <#assign destroy_args='${destroy_args} -parallelism=${previousDeployed.parallelism}'/>
</#if>

<#if previousDeployed.targets??>
    <#list previousDeployed.targets as target>
        <#assign destroy_args='${destroy_args} -target=${target}'/>
    </#list>
</#if>

<#if previousDeployed.inputVariables??>
    <#list previousDeployed.inputVariables?keys as key>
        <#assign destroy_args='${destroy_args} -var ${key}="${previousDeployed.inputVariables[key]?j_string}"'/>
    </#list>
</#if>

<#assign destroy_args_obfuscated="${destroy_args}"/>

<#if previousDeployed.secretInputVariables??>
    <#list previousDeployed.secretInputVariables?keys as key>
        <#assign destroy_args="${destroy_args} -var ${key}=\"${previousDeployed.secretInputVariables[key]?j_string}\""/>
        <#assign destroy_args_obfuscated="${destroy_args_obfuscated} -var ${key}=\"********\""/>
    </#list>
</#if>

<#assign terraform_destroy="'${previousDeployed.container.path}/terraform' destroy" />
<#assign terraform_command='${terraform_destroy} ${destroy_args}' />
<#assign terraform_command_obfuscated='${terraform_destroy} ${destroy_args_obfuscated}' />

echo "Changing working directory to ${workingDirectory}"
cd '${workingDirectory}'

echo "Cleaning up working directory and copying scripts from ${previousDeployed.file.path}.."
find . -name '*.tf' -delete
${previousDeployed.container.cpCommand} '${previousDeployed.file.path}/'* '${workingDirectory}'

echo Executing ${terraform_command_obfuscated}
${terraform_command}
