#!/bin/bash

<#assign workingDirectory='${deployed.container.workingDirectory}/${deployed.name}'/>

<#assign init_args='-input=false -no-color'/>

<#if deployed.container.pluginDirectory??>
    <#assign init_args='-plugin-dir ${deployed.container.pluginDirectory}'/>
</#if>

<#assign terraform_init="'${deployed.container.path}/terraform' init ${init_args}" />
<#assign terraform_command='${terraform_init}' />

mkdir -p '${workingDirectory}'
echo "Changing working directory to ${workingDirectory}"
cd '${workingDirectory}'

echo "Cleaning up working directory and copying scripts from ${deployed.file.path}.."
find . ! -name '*.tfstate' -delete
${deployed.container.cpCommand} '${deployed.file.path}/'* '${workingDirectory}'

echo "Executing ${terraform_command}"
${terraform_command}
