XLRELEASE_HOME=${deployed.container.homeDir}
xlr_user=xl-release
xlr_group=xl-release

mkdir -p $XLRELEASE_HOME

echo Unzipping archive in $XLRELEASE_HOME
rm -rf $XLRELEASE_HOME/${deployed.deployitServerDir}
unzip -q ${deployed.file} -d $XLRELEASE_HOME

if ! id $xlr_user > /dev/null 2>&1; then
  echo Creating service account $xlr_user
  useradd -d $XLRELEASE_HOME/${deployed.deployitServerDir} -M -r $xlr_user
else
  echo Service account $xlr_user already exists
fi

# Set things up so the service user has write permissions only in places
# where it needs it.
chgrp $xlr_group $XLRELEASE_HOME/xl-release-license.lic
echo Restricting file permissions on $XLRELEASE_HOME/${deployed.deployitServerDir}
chown -R root.$xlr_group $XLRELEASE_HOME/${deployed.deployitServerDir}
chmod -R u=rwX,g=rX,o-rwx $XLRELEASE_HOME/${deployed.deployitServerDir}
chmod u=rwX,g=rwX,o-rwx $XLRELEASE_HOME/${deployed.deployitServerDir}
for i in repository archive log conf; do
  d=$XLRELEASE_HOME/${deployed.deployitServerDir}/$i
  [ -d $d ] || mkdir $d
  chown root.$xlr_group $d
  chmod -R u=rwX,g=rwX,o-rwx $d
done

cd $XLRELEASE_HOME/${deployed.deployitServerDir}

# Link to license installed on container
ln -s $XLRELEASE_HOME/xl-release-license.lic conf/

echo Initializing XL Release version ${deployed.deployitServerDir}
sudo -u $xlr_user bin/server.sh -setup -force -reinitialize -setup-defaults  ${step.remoteWorkingDirectory.path}/server.conf.defaults

cd ..
rm -f current-version
ln -s ${deployed.deployitServerDir} current-version
