/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.WinrmHttpsCertificateTrustStrategy;
import com.xebialabs.overthere.cifs.WinrmHttpsHostnameVerificationStrategy;
import com.xebialabs.overthere.cifs.telnet.CifsTelnetConnection;
import com.xebialabs.overthere.cifs.winrm.CifsWinRmConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import java.util.Map;

@Protocol(name="cifs")
public class CifsConnectionBuilder
implements OverthereConnectionBuilder {
    public static final String CIFS_PROTOCOL = "cifs";
    public static final String CONNECTION_TYPE = "connectionType";
    public static final int DEFAULT_TELNET_PORT = 23;
    public static final int DEFAULT_WINRM_HTTP_PORT = 5985;
    public static final int DEFAULT_WINRM_HTTPS_PORT = 5986;
    public static final String CIFS_PORT = "cifsPort";
    public static final int DEFAULT_CIFS_PORT = 445;
    public static final String PATH_SHARE_MAPPINGS = "pathShareMappings";
    public static final Map<String, String> PATH_SHARE_MAPPINGS_DEFAULT = ImmutableMap.of();
    public static final String WINRM_ENABLE_HTTPS = "winrmEnableHttps";
    public static final boolean DEFAULT_WINRM_ENABLE_HTTPS = false;
    public static final String WINRM_CONTEXT = "winrmContext";
    public static final String DEFAULT_WINRM_CONTEXT = "/wsman";
    public static final String WINRM_ENVELOP_SIZE = "winrmEnvelopSize";
    public static final int DEFAULT_WINRM_ENVELOP_SIZE = 153600;
    public static final String WINRM_HTTPS_CERTIFICATE_TRUST_STRATEGY = "winrmHttpsCertificateTrustStrategy";
    public static final WinrmHttpsCertificateTrustStrategy DEFAULT_WINRM_HTTPS_CERTIFICATE_TRUST_STRATEGY = WinrmHttpsCertificateTrustStrategy.STRICT;
    public static final String WINRM_HTTPS_HOSTNAME_VERIFICATION_STRATEGY = "winrmHttpsHostnameVerificationStrategy";
    public static final WinrmHttpsHostnameVerificationStrategy DEFAULT_WINRM_HTTPS_HOSTNAME_VERIFICATION_STRATEGY = WinrmHttpsHostnameVerificationStrategy.BROWSER_COMPATIBLE;
    public static final String WINRM_KERBEROS_DEBUG = "winrmKerberosDebug";
    public static final boolean DEFAULT_WINRM_KERBEROS_DEBUG = false;
    public static final String WINRM_KERBEROS_USE_HTTP_SPN = "winrmKerberosUseHttpSpn";
    public static final boolean DEFAULT_WINRM_KERBEROS_USE_HTTP_SPN = false;
    public static final String WINRM_KERBEROS_ADD_PORT_TO_SPN = "winrmKerberosAddPortToSpn";
    public static final boolean DEFAULT_WINRM_KERBEROS_ADD_PORT_TO_SPN = false;
    public static final String WINRM_LOCALE = "winrmLocale";
    public static final String DEFAULT_WINRM_LOCALE = "en-US";
    public static final String WINRM_TIMEMOUT = "winrmTimeout";
    public static final String DEFAULT_WINRM_TIMEOUT = "PT60.000S";
    private OverthereConnection connection;

    public CifsConnectionBuilder(String type, ConnectionOptions options, AddressPortMapper mapper) {
        CifsConnectionType cifsConnectionType = options.getEnum(CONNECTION_TYPE, CifsConnectionType.class);
        switch (cifsConnectionType) {
            case TELNET: {
                this.connection = new CifsTelnetConnection(type, options, mapper);
                break;
            }
            case WINRM: {
                this.connection = new CifsWinRmConnection(type, options, mapper);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CIFS connection type " + (Object)((Object)cifsConnectionType));
            }
        }
    }

    @Override
    public OverthereConnection connect() {
        return this.connection;
    }

    public String toString() {
        return ((Object)this.connection).toString();
    }
}

