/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.Monitor;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshProcess;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshTunnelConnection
extends SshConnection
implements AddressPortMapper {
    private static final Monitor M = new Monitor();
    static final AtomicReference<TunnelPortManager> PORT_MANAGER = new AtomicReference<TunnelPortManager>(new TunnelPortManager());
    private static final int MAX_PORT = 65536;
    private Map<InetSocketAddress, InetSocketAddress> localPortForwards = Maps.newHashMap();
    private List<PortForwarder> portForwarders = Lists.newArrayList();
    private Integer startPortRange;
    private static final Logger logger = LoggerFactory.getLogger(SshTunnelConnection.class);

    public SshTunnelConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, options, mapper);
        this.startPortRange = options.get("portAllocationRangeStart", 1025);
    }

    @Override
    protected void connect() {
        super.connect();
        Preconditions.checkState((this.sshClient != null ? 1 : 0) != 0, (Object)"Should have set an SSH client when connected");
    }

    @Override
    public void doClose() {
        logger.debug("Closing tunnel.");
        for (PortForwarder portForwarder : this.portForwarders) {
            Closeables.closeQuietly((Closeable)portForwarder);
        }
        super.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetSocketAddress map(InetSocketAddress address) {
        M.enter();
        try {
            if (this.localPortForwards.containsKey(address)) {
                InetSocketAddress inetSocketAddress = this.localPortForwards.get(address);
                return inetSocketAddress;
            }
            ServerSocket serverSocket = PORT_MANAGER.get().leaseNewPort(this.startPortRange);
            this.portForwarders.add(this.startForwarder(address, serverSocket));
            InetSocketAddress localAddress = InetSocketAddress.createUnresolved("localhost", serverSocket.getLocalPort());
            this.localPortForwards.put(address, localAddress);
            InetSocketAddress inetSocketAddress = localAddress;
            return inetSocketAddress;
        }
        finally {
            M.leave();
        }
    }

    private PortForwarder startForwarder(InetSocketAddress remoteAddress, ServerSocket serverSocket) {
        PortForwarder forwarderThread = new PortForwarder(this.sshClient, remoteAddress, serverSocket);
        logger.info("Starting {}", (Object)forwarderThread.getName());
        forwarderThread.start();
        try {
            forwarderThread.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return forwarderThread;
    }

    @Override
    public OverthereFile getFile(String hostPath) throws RuntimeIOException {
        throw new UnsupportedOperationException("Cannot get a file from the tunnel.");
    }

    @Override
    public OverthereProcess startProcess(CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot start a process on the tunnel.");
    }

    @Override
    protected CmdLine processCommandLine(CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot process a command line for the tunnel.");
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        throw new UnsupportedOperationException("Cannot create a process in the tunnel.");
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        throw new UnsupportedOperationException("Cannot set a working directory on the tunnel.");
    }

    @Override
    public OverthereFile getWorkingDirectory() {
        throw new UnsupportedOperationException("Cannot get a working directory from the tunnel.");
    }

    @Override
    public int execute(OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot execute a command on the tunnel.");
    }

    static class TunnelPortManager {
        private static final Set<Integer> portsHandedOut = Sets.newHashSet();
        private static Monitor M = new Monitor();

        TunnelPortManager() {
        }

        ServerSocket leaseNewPort(Integer startFrom) {
            M.enter();
            try {
                for (int port = startFrom.intValue(); port < 65536; ++port) {
                    ServerSocket socket;
                    if (this.isLeased(port) || (socket = this.tryBind(port)) == null) continue;
                    portsHandedOut.add(port);
                    ServerSocket serverSocket = socket;
                    return serverSocket;
                }
                throw new IllegalStateException(String.format("Could not find a single free port in the range [%s-%s]...", startFrom, 65536));
            }
            finally {
                M.leave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void returnPort(ServerSocket socket) {
            M.enter();
            try {
                portsHandedOut.remove(socket.getLocalPort());
            }
            finally {
                M.leave();
            }
        }

        private boolean isLeased(int port) {
            return portsHandedOut.contains(port);
        }

        protected ServerSocket tryBind(int localPort) {
            try {
                ServerSocket ss = new ServerSocket();
                ss.setReuseAddress(true);
                ss.bind(new InetSocketAddress("localhost", localPort));
                return ss;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static class PortForwarder
    extends Thread
    implements Closeable {
        private final SSHClient sshClient;
        private final InetSocketAddress remoteAddress;
        private final ServerSocket localSocket;
        private CountDownLatch latch = new CountDownLatch(1);

        public PortForwarder(SSHClient sshClient, InetSocketAddress remoteAddress, ServerSocket localSocket) {
            super(PortForwarder.buildName(remoteAddress, localSocket.getLocalPort()));
            this.sshClient = sshClient;
            this.remoteAddress = remoteAddress;
            this.localSocket = localSocket;
        }

        private static String buildName(InetSocketAddress remoteAddress, Integer localPort) {
            return String.format("SSH local port forward thread [%d:%s]", localPort, remoteAddress.toString());
        }

        @Override
        public void run() {
            LocalPortForwarder.Parameters params = new LocalPortForwarder.Parameters("localhost", this.localSocket.getLocalPort(), this.remoteAddress.getHostName(), this.remoteAddress.getPort());
            LocalPortForwarder forwarder = this.sshClient.newLocalPortForwarder(params, this.localSocket);
            try {
                this.latch.countDown();
                forwarder.listen();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            this.localSocket.close();
            PORT_MANAGER.get().returnPort(this.localSocket);
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

