/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereFileDirectoryWalker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OverthereFileCopier
extends OverthereFileDirectoryWalker {
    private static final String SOURCE = "Source";
    private static final String DESTINATION = "Destination";
    private Stack<OverthereFile> dstDirStack = new Stack();
    private OverthereFile srcDir;
    private static Logger logger = LoggerFactory.getLogger(OverthereFileCopier.class);

    private OverthereFileCopier(OverthereFile srcDir, OverthereFile dstDir) {
        this.dstDirStack.push(dstDir);
        this.srcDir = srcDir;
        OverthereFileCopier.checkDirectoryExists(srcDir, SOURCE);
    }

    @Override
    protected void handleDirectoryStart(OverthereFile scrDir, int depth) throws IOException {
        OverthereFile dstDir = this.getCurrentDestinationDir();
        if (depth != 0) {
            dstDir = this.createSubdirectoryAndMakeCurrent(dstDir, scrDir.getName());
        }
        if (dstDir.exists()) {
            OverthereFileCopier.checkReallyIsADirectory(dstDir, DESTINATION);
            logger.debug("About to copy files into existing directory {}", (Object)dstDir);
        } else {
            logger.debug("Creating destination directory {}", (Object)dstDir);
            dstDir.mkdir();
        }
    }

    private OverthereFile createSubdirectoryAndMakeCurrent(OverthereFile parentDir, String subdirName) {
        OverthereFile subdir = parentDir.getFile(subdirName);
        this.dstDirStack.push(subdir);
        return subdir;
    }

    private void startCopy() {
        this.walk(this.srcDir);
    }

    private OverthereFile getCurrentDestinationDir() {
        return this.dstDirStack.peek();
    }

    @Override
    protected void handleFile(OverthereFile srcFile, int depth) throws IOException {
        OverthereFile dstFile = this.getCurrentDestinationDir().getFile(srcFile.getName());
        OverthereFileCopier.copyFile(srcFile, dstFile);
    }

    @Override
    protected void handleDirectoryEnd(OverthereFile directory, int depth) throws IOException {
        if (depth != 0) {
            this.dstDirStack.pop();
        }
    }

    public static void copy(OverthereFile src, OverthereFile dst) {
        if (src.isDirectory()) {
            OverthereFileCopier.copyDirectory(src, dst);
        } else {
            OverthereFileCopier.copyFile(src, dst);
        }
    }

    private static void copyDirectory(OverthereFile srcDir, OverthereFile dstDir) throws RuntimeIOException {
        OverthereFileCopier dirCopier = new OverthereFileCopier(srcDir, dstDir);
        dirCopier.startCopy();
    }

    private static void copyFile(final OverthereFile srcFile, final OverthereFile dstFile) throws RuntimeIOException {
        OverthereFileCopier.checkFileExists(srcFile, SOURCE);
        OverthereFileCopier.checkReallyIsAFile(dstFile, DESTINATION);
        if (dstFile.exists()) {
            logger.debug("About to overwrite existing file {}", (Object)dstFile);
        }
        logger.debug("Copying file {} to {}", (Object)srcFile, (Object)dstFile);
        try {
            ByteStreams.copy((InputSupplier)new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return new BufferedInputStream(srcFile.getInputStream());
                }
            }, (OutputSupplier)new OutputSupplier<OutputStream>(){

                public OutputStream getOutput() throws IOException {
                    return new BufferedOutputStream(dstFile.getOutputStream());
                }
            });
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot copy " + srcFile + " to " + dstFile, exc);
        }
    }

    private static void checkFileExists(OverthereFile file, String sourceDescription) {
        if (!file.exists()) {
            throw new RuntimeIOException(sourceDescription + " file " + file + " does not exist");
        }
        OverthereFileCopier.checkReallyIsAFile(file, sourceDescription);
    }

    private static void checkReallyIsAFile(OverthereFile file, String fileDescription) {
        if (file.exists() && file.isDirectory()) {
            throw new RuntimeIOException(fileDescription + " file " + file + " exists but is a directory");
        }
    }

    private static void checkDirectoryExists(OverthereFile dir, String dirDescription) {
        if (!dir.exists()) {
            throw new RuntimeIOException(dirDescription + " directory " + dir + " does not exist");
        }
        OverthereFileCopier.checkReallyIsADirectory(dir, dirDescription);
    }

    private static void checkReallyIsADirectory(OverthereFile dir, String dirDescription) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new RuntimeIOException(dirDescription + " directory " + dir + " exists but is not a directory");
        }
    }
}

