/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.controltask;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.deployment.planner.StepAdapter;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ControlTaskService {
    private static final String CLOUD_PARAMS_ENVIRONMENT_ID = "environmentId";

    public TaskSpecification prepareControlTask(ConfigurationItem ci, String controlTaskName, Parameters params, WorkDir workDir) {
        MethodDescriptor method = DescriptorRegistry.getDescriptor((Type)ci.getType()).getControlTask(controlTaskName);
        Checks.checkArgument((method != null ? 1 : 0) != 0, (String)"ConfigurationItem %s of type %s does not have a control task named %s.", (Object[])new Object[]{ci.getId(), ci.getType(), controlTaskName});
        List steps = (List)method.invoke(ci, params);
        ArrayList flowSteps = Lists.newArrayList();
        for (Object step : steps) {
            flowSteps.add(new TaskStep(StepAdapter.wrapIfNeeded(step)));
        }
        TaskSpecification taskSpecification = new TaskSpecification(String.format("Control task [%s] for %s", controlTaskName, ci.getId()), Permissions.getAuthentication().getName(), (List)flowSteps);
        taskSpecification.getListeners().add(new WorkdirCleanerTrigger(workDir));
        Map metadata = taskSpecification.getMetadata();
        metadata.put("taskType", TaskType.CONTROL.name());
        metadata.put("taskName", controlTaskName);
        if ("destroy".equals(controlTaskName)) {
            if (ci.getType().instanceOf(Type.valueOf((String)"cloud.Environment"))) {
                metadata.put("cloudOperation", controlTaskName);
                metadata.put("cloudEnvironmentId", ci.getId());
                BaseConfigurationItem envTemplate = (BaseConfigurationItem)ci.getProperty("template");
                metadata.put("cloudEnvironmentTemplateId", envTemplate.getId());
            }
        } else if ("instantiate".equals(controlTaskName) && params.getType().instanceOf(Type.valueOf((String)"cloud.CloudEnvironmentParameters"))) {
            metadata.put("cloudOperation", controlTaskName);
            metadata.put("cloudEnvironmentTemplateId", ci.getId());
            metadata.put("cloudEnvironmentId", params.getProperty(CLOUD_PARAMS_ENVIRONMENT_ID));
        }
        return taskSpecification;
    }
}

