/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TagMatcher {
    private static final Logger logger = LoggerFactory.getLogger(TagMatcher.class);

    public boolean areMatching(Deployable deployable, Container container) {
        Set<String> deployableTags = this.emptySetIfNull(deployable.getTags());
        Set<String> containerTags = this.emptySetIfNull(container.getTags());
        logger.debug("Using tags: deployable {} and container {}", deployableTags, containerTags);
        boolean bothEmpty = this.bothEmpty(deployableTags, containerTags);
        boolean tagMatching = this.haveAMatchingTag(deployableTags, containerTags);
        boolean containsStar = this.hasStarWildcard(deployableTags) || this.hasStarWildcard(containerTags);
        boolean containsPlus = this.hasPlusWildcard(deployableTags, containerTags) || this.hasPlusWildcard(containerTags, deployableTags);
        return bothEmpty || tagMatching || containsStar || containsPlus;
    }

    private boolean hasPlusWildcard(Set<String> tags, Set<String> otherTags) {
        return tags.contains("+") && !otherTags.isEmpty();
    }

    private boolean hasStarWildcard(Set<String> tags) {
        return tags.contains("*");
    }

    private boolean haveAMatchingTag(Set<String> deployableTags, Set<String> containerTags) {
        return !Sets.intersection(deployableTags, containerTags).isEmpty();
    }

    private boolean bothEmpty(Set<String> deployableTags, Set<String> containerTags) {
        return deployableTags.isEmpty() && containerTags.isEmpty();
    }

    private Set<String> emptySetIfNull(Set<String> tags) {
        if (tags == null) {
            return Sets.newHashSet();
        }
        return tags;
    }
}

