/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.List;
import java.util.Map;

public abstract class AbstractTaskConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TaskState t = (TaskState)source;
        writer.addAttribute("id", t.getId());
        writer.addAttribute("currentStep", Integer.toString(t.getCurrentStepNr()));
        writer.addAttribute("totalSteps", Integer.toString(t.getNrSteps()));
        writer.addAttribute("failures", Integer.toString(t.getFailureCount()));
        writer.addAttribute("state", t.getState().name());
        writer.addAttribute("owner", t.getOwner());
        Converters.writeNode("description", t.getDescription(), writer);
        if (t.getStartDate() != null) {
            Converters.writeNode("startDate", new DateTimeAdapter().marshal(t.getStartDate()), writer);
        }
        if (t.getCompletionDate() != null) {
            Converters.writeNode("completionDate", new DateTimeAdapter().marshal(t.getCompletionDate()), writer);
        }
        Map metadata = t.getMetadata();
        writer.startNode("metadata");
        for (Map.Entry e : metadata.entrySet()) {
            Converters.writeNode((String)e.getKey(), (String)e.getValue(), writer);
        }
        writer.endNode();
        if (t instanceof TaskWithSteps) {
            this.writeSteps(writer, context, (TaskWithSteps)t);
        }
    }

    private void writeSteps(HierarchicalStreamWriter writer, MarshallingContext context, TaskWithSteps t) {
        List steps = t.getSteps();
        writer.startNode("steps");
        for (StepState step : steps) {
            writer.startNode("step");
            context.convertAnother((Object)step);
            writer.endNode();
        }
        writer.endNode();
    }

    public boolean canConvert(Class type) {
        return TaskState.class.isAssignableFrom(type);
    }
}

