/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class DeploymentsKeyIndicator
extends TaskArchiveReport {
    public DeploymentsKeyIndicator(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    public Report report() {
        final ConcurrentMap tasks = new MapMaker().makeComputingMap((Function)new Function<String, TaskStateData>(){

            public TaskStateData apply(String input) {
                return new TaskStateData();
            }
        });
        this.taskArchive.searchTasksWithoutLoadingSteps(this.getSearchParameters(), new JcrTaskArchive.TaskCallback(){

            public void doWithTask(ArchivedTask task) {
                DeploymentsKeyIndicator.addTask(tasks, (TaskState)task);
            }
        });
        return DeploymentsKeyIndicator.generateReport(tasks);
    }

    private static Report generateReport(Map<String, TaskStateData> tasksMap) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasksMap.entrySet()) {
            TaskStateData task = entry.getValue();
            Report.ReportLine line = report.addLine();
            String envId = entry.getKey().split("~", 2)[1];
            line.addValue("application", (Object)entry.getKey().substring(0, entry.getKey().indexOf("~")));
            line.addValue("environment", (Object)envId.substring(envId.indexOf("/") + 1));
            line.addValue("environmentId", (Object)envId);
            line.addValue("environmentIdWithoutRoot", (Object)envId.split("/", 2)[1]);
            line.addValue("noOfSuccessfulDeployments", (Object)task.getNoOfSuccessfulDeployments().toString());
            line.addValue("noOfFailedDeployments", (Object)task.getNoOfFailedDeployments().toString());
            line.addValue("noOfAbortedDeployments", (Object)task.getNoOfAbortedDeployments().toString());
            line.addValue("noOfRollbacks", (Object)task.getNoOfRollbacks().toString());
            line.addValue("averageDuration", (Object)DeploymentsKeyIndicator.getAverageDeploymentTime(task));
        }
        return report;
    }

    static String getAverageDeploymentTime(TaskStateData task) {
        if (task.getTotalSuccessfulTasks() > 0) {
            return ReportUtils.formatToHoursMinsSecs(task.getAverageDeploymentTime() / (long)task.getTotalSuccessfulTasks());
        }
        return "00:00:00";
    }

    private static void addTask(Map<String, TaskStateData> tasks, TaskState task) {
        String entityId = TaskMetadata.getMetadata((TaskState)task, (String)"application") + "~" + TaskMetadata.getMetadata((TaskState)task, (String)"environment_id");
        tasks.get(entityId).addTaskAndDuration(task);
    }
}

