/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.LicenseUtil;
import com.xebialabs.license.UnableToValidateLicenseException;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.v1.License;
import java.io.File;
import java.io.IOException;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseServiceImpl
implements LicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private File licenseFile;
    private License license;

    @Override
    public boolean isLicenseExpired() {
        if (this.license != null && !LocalDate.now().isAfter((ReadablePartial)this.license.getExpiresAfter())) {
            return false;
        }
        this.readLicense();
        return this.license == null || LocalDate.now().isAfter((ReadablePartial)this.license.getExpiresAfter());
    }

    public LicenseServiceImpl(String configDir) throws IOException {
        this.licenseFile = new File(configDir, "deployit-license.lic");
        if (this.isLicenseExpired()) {
            log.warn("***");
            log.warn("*** Your Deployit license was not found, is invalid, or has expired; Deployit will not run.");
            log.warn("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
            log.warn("*** Place a valid license in {} to continue using Deployit", (Object)this.licenseFile.getAbsolutePath());
            log.warn("***");
        }
    }

    private void readLicense() {
        String licenseFilePath = this.licenseFile.getAbsolutePath();
        if (!this.licenseFile.exists()) {
            log.warn("License file {} not found; Deployit will not function without it!", (Object)licenseFilePath);
            return;
        }
        try {
            log.info("Reading license from file {}", (Object)licenseFilePath);
            this.license = LicenseUtil.readLicense(this.licenseFile);
        }
        catch (InvalidLicenseException ex) {
            log.warn("License is invalid; Deployit will not run without a valid license!", (Object)licenseFilePath);
            log.warn(ex.getMessage(), (Throwable)ex);
            return;
        }
        catch (UnableToValidateLicenseException ex) {
            log.warn("License could not be validated; Deployit will not run without a valid license!", (Object)licenseFilePath);
            log.warn(ex.getMessage(), (Throwable)ex);
            return;
        }
        log.info("Licensed to: {}", (Object)this.license.getLicensedTo());
        log.info("License contact: {}", (Object)this.license.getContact());
        log.info("License expires after: {}", (Object)this.license.getExpiresAfter());
        if (LocalDate.now().isAfter((ReadablePartial)this.license.getExpiresAfter())) {
            log.warn("*** NOTE: this license has expired!");
        }
    }
}

