/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.swing;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileComparator;
import de.schlichtherle.truezip.file.swing.TFileTreeCellRenderer;
import de.schlichtherle.truezip.file.swing.TFileTreeModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@DefaultAnnotation(value={NonNull.class})
public final class TFileTree
extends JTree {
    private static final long serialVersionUID = 1064787562479927601L;
    private static final String PROPERTY_DISPLAYING_SUFFIXES = "displayingSuffixes";
    private static final String PROPERTY_EDITING_SUFFIXES = "editingSuffixes";
    private static final String PROPERTY_DEFAULT_SUFFIX = "defaultSuffix";
    private final Controller controller = new Controller();
    private boolean displayingSuffixes = true;
    private boolean editingSuffixes = true;
    @CheckForNull
    private String defaultSuffix;
    @CheckForNull
    private transient TFile editedNode;

    public TFileTree() {
        this(new TFileTreeModel(null, null, new TFileComparator()));
    }

    public TFileTree(TFile root) {
        this(new TFileTreeModel(root, null, new TFileComparator()));
    }

    public TFileTree(TFileTreeModel model) {
        super(model);
        super.addTreeExpansionListener(this.controller);
        super.setCellRenderer(new TFileTreeCellRenderer(this));
    }

    @Override
    public TFileTreeModel getModel() {
        return (TFileTreeModel)super.getModel();
    }

    @Override
    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void setModel(TreeModel model) {
        if (null == model) {
            throw new NullPointerException();
        }
        super.setModel((TFileTreeModel)model);
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable) {
            super.setEditable(true);
            this.getCellEditor().addCellEditorListener(this.controller);
        } else {
            TreeCellEditor ce = this.getCellEditor();
            if (ce != null) {
                ce.removeCellEditorListener(this.controller);
            }
            super.setEditable(false);
        }
    }

    public boolean isDisplayingSuffixes() {
        return this.displayingSuffixes;
    }

    public void setDisplayingSuffixes(boolean displayingSuffixes) {
        boolean oldDisplayingSuffixes = this.displayingSuffixes;
        this.displayingSuffixes = displayingSuffixes;
        this.firePropertyChange(PROPERTY_DISPLAYING_SUFFIXES, oldDisplayingSuffixes, displayingSuffixes);
    }

    public boolean isEditingSuffixes() {
        return this.editingSuffixes;
    }

    public void setEditingSuffixes(boolean editingSuffixes) {
        boolean oldEditingSuffixes = this.editingSuffixes;
        this.editingSuffixes = editingSuffixes;
        this.firePropertyChange(PROPERTY_EDITING_SUFFIXES, oldEditingSuffixes, editingSuffixes);
    }

    @Nullable
    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public void setDefaultSuffix(@CheckForNull String defaultSuffix) {
        String oldDefaultSuffix = this.defaultSuffix;
        if (null != defaultSuffix) {
            if ((defaultSuffix = defaultSuffix.trim()).length() <= 0) {
                defaultSuffix = null;
            } else if (defaultSuffix.charAt(0) != '.') {
                defaultSuffix = "." + defaultSuffix;
            }
        }
        this.defaultSuffix = defaultSuffix;
        this.firePropertyChange(PROPERTY_DEFAULT_SUFFIX, oldDefaultSuffix, defaultSuffix);
    }

    @Nullable
    TFile getEditedNode() {
        return this.editedNode;
    }

    @Override
    public boolean isEditing() {
        return null != this.editedNode;
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        this.editedNode = (TFile)path.getLastPathComponent();
        super.startEditingAtPath(path);
    }

    @Override
    public void cancelEditing() {
        this.editedNode = null;
        super.cancelEditing();
    }

    @Override
    public boolean stopEditing() {
        boolean stop = super.stopEditing();
        if (stop) {
            this.editedNode = null;
        }
        return stop;
    }

    protected void onEditingStopped(ChangeEvent evt) {
        TreeCellEditor tce = (TreeCellEditor)evt.getSource();
        String member = tce.getCellEditorValue().toString().trim();
        TFile oldNode = (TFile)this.getLeadSelectionPath().getLastPathComponent();
        TFile parent = oldNode.getParentFile();
        assert (parent != null);
        if (!oldNode.isDirectory()) {
            String suffix;
            if (this.isDisplayingSuffixes() && this.isEditingSuffixes()) {
                String defaultSuffix;
                suffix = this.getSuffix(member);
                if (null == suffix && (defaultSuffix = this.getDefaultSuffix()) != null) {
                    member = member + defaultSuffix;
                }
            } else {
                suffix = this.getSuffix(oldNode.getName());
                if (null != suffix) {
                    member = member + suffix;
                }
            }
        }
        TFile node = new TFile((File)parent, member);
        try {
            this.mv(oldNode, node);
        }
        catch (IOException ex) {
            Logger.getLogger(TFileTree.class.getName()).log(Level.WARNING, ex.toString(), ex);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Nullable
    private String getSuffix(String base) {
        int i = base.lastIndexOf(46);
        return i != -1 ? base.substring(i) : null;
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TFile node = (TFile)value;
        TFile editedNode = this.getEditedNode();
        if (node != editedNode && !node.exists()) {
            return "?";
        }
        String base = node.getName();
        if (base.length() <= 0) {
            return node.getPath();
        }
        if (node.isDirectory() || this.isDisplayingSuffixes() && (!node.equals(editedNode) || this.isEditingSuffixes())) {
            return base;
        }
        int i = base.lastIndexOf(46);
        return i != -1 ? base.substring(0, i) : base;
    }

    public void refresh() {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(ftm.getRoot());
        if (null != path) {
            this.refresh(new TreePath[]{path});
        }
    }

    public void refresh(TFile node) {
        if (node == null) {
            throw new NullPointerException();
        }
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path != null) {
            this.refresh(new TreePath[]{path});
        }
    }

    public void refresh(TreePath[] paths) {
        if (paths == null || paths.length <= 0) {
            return;
        }
        TFileTreeModel ftm = this.getModel();
        TreePath lead = this.getLeadSelectionPath();
        TreePath anchor = this.getAnchorSelectionPath();
        TreePath[] selections = this.getSelectionPaths();
        for (TreePath path : paths) {
            Enumeration<TreePath> expansions = this.getExpandedDescendants(path);
            ftm.refresh((TFile)path.getLastPathComponent());
            this.setExpandedDescendants(expansions);
        }
        this.setSelectionPaths(selections);
        this.setAnchorSelectionPath(anchor);
        this.setLeadSelectionPath(lead);
        this.scrollPathToVisible(lead);
    }

    private void setExpandedDescendants(Enumeration<TreePath> expansions) {
        if (expansions == null) {
            return;
        }
        while (expansions.hasMoreElements()) {
            this.setExpandedState(expansions.nextElement(), true);
        }
    }

    public boolean createNewFile(TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            return false;
        }
        if (!ftm.createNewFile(node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public void mkdir(TFile node, boolean recursive) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            return;
        }
        ftm.mkdir(node, recursive);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp(InputStream in, TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp(in, node);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp(TFile oldNode, TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp(oldNode, node);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp_r(TFile oldNode, TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp_r(oldNode, node);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp_p(TFile oldNode, TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp_p(oldNode, node);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void cp_rp(TFile oldNode, TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        ftm.cp_rp(oldNode, node);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void mv(TFile oldNode, TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        TreePath oldPath = ftm.newTreePath(oldNode);
        Enumeration<TreePath> expansions = oldPath == null ? null : this.getExpandedDescendants(oldPath);
        ftm.mv(oldNode, node);
        if (null != expansions) {
            while (expansions.hasMoreElements()) {
                this.setExpandedState(this.substPath(expansions.nextElement(), oldPath, path), true);
            }
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    private TreePath substPath(TreePath tp, TreePath oldPath, TreePath path) {
        TFile file = (TFile)tp.getLastPathComponent();
        if (file.equals(oldPath.getLastPathComponent())) {
            return path;
        }
        TreePath parent = this.substPath(tp.getParentPath(), oldPath, path);
        return parent.pathByAddingChild(new TFile((File)((TFile)parent.getLastPathComponent()), file.getName()));
    }

    public void rm(TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        this.scrollPathToVisible(path);
        int row = this.getRowForPath(path);
        ftm.rm(node);
        this.setSelectionRow(row);
    }

    public void rm_r(TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null == path) {
            throw new IllegalArgumentException("node");
        }
        this.scrollPathToVisible(path);
        int row = this.getRowForPath(path);
        ftm.rm_r(node);
        this.setSelectionRow(row);
    }

    public void setSelectionNode(TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (null != path) {
            this.setSelectionPath(path);
        }
    }

    public void setSelectionNodes(TFile[] nodes) {
        TFileTreeModel ftm = this.getModel();
        LinkedList<TreePath> list = new LinkedList<TreePath>();
        TreePath lastPath = null;
        int l = nodes.length;
        for (int i = 0; i < l; ++i) {
            lastPath = ftm.newTreePath(nodes[i]);
            if (lastPath == null) continue;
            list.add(lastPath);
        }
        int size = list.size();
        if (size > 0) {
            TreePath[] paths = new TreePath[size];
            list.toArray(paths);
            this.setSelectionPaths(paths);
        }
    }

    public void scrollNodeToVisible(TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path != null) {
            this.scrollPathToVisible(path);
        }
    }

    private final class Controller
    implements TreeExpansionListener,
    CellEditorListener,
    Serializable {
        private static final long serialVersionUID = 6402557248752695675L;

        private Controller() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
            TFileTree.this.getModel().forget((TFile)evt.getPath().getLastPathComponent());
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
        }

        @Override
        public void editingCanceled(ChangeEvent evt) {
        }

        @Override
        public void editingStopped(ChangeEvent evt) {
            TFileTree.this.onEditingStopped(evt);
        }
    }
}

