/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JointIterator;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class FsMultiplexedOutputShop<AE extends FsArchiveEntry>
extends DecoratingOutputShop<AE, OutputShop<AE>> {
    private final IOPool<?> pool;
    private final Map<String, BufferedEntryOutputStream> buffers = new LinkedHashMap<String, BufferedEntryOutputStream>();
    private boolean busy;

    public FsMultiplexedOutputShop(OutputShop<AE> output, IOPool<?> pool) {
        super(output);
        if (null == pool) {
            throw new NullPointerException();
        }
        this.pool = pool;
    }

    @Override
    public int getSize() {
        return ((OutputShop)this.delegate).getSize() + this.buffers.size();
    }

    @Override
    public Iterator<AE> iterator() {
        return new JointIterator(((OutputShop)this.delegate).iterator(), new BufferedEntriesIterator());
    }

    @Override
    @CheckForNull
    public AE getEntry(String name) {
        FsArchiveEntry entry = (FsArchiveEntry)((OutputShop)this.delegate).getEntry(name);
        if (null != entry) {
            return (AE)entry;
        }
        BufferedEntryOutputStream out = this.buffers.get(name);
        return null == out ? null : (AE)out.getTarget();
    }

    @Override
    public OutputSocket<? extends AE> getOutputSocket(AE entry) {
        if (null == entry) {
            throw new NullPointerException();
        }
        class Output
        extends DecoratingOutputSocket<AE> {
            final /* synthetic */ FsArchiveEntry val$entry;

            Output() {
                this.val$entry = fsArchiveEntry;
                super(FsMultiplexedOutputShop.super.getOutputSocket(fsArchiveEntry));
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                if (FsMultiplexedOutputShop.this.isBusy()) {
                    IOPool.Entry temp = (IOPool.Entry)FsMultiplexedOutputShop.this.pool.allocate();
                    try {
                        return new BufferedEntryOutputStream(temp, this.getBoundSocket());
                    }
                    catch (IOException ex) {
                        try {
                            temp.release();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw ex;
                    }
                }
                return new EntryOutputStream(this.getBoundSocket().newOutputStream());
            }
        }
        return new Output();
    }

    public boolean isBusy() {
        return this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.isBusy()) {
            throw new IOException("Output shop is still busy!");
        }
        try {
            this.storeBuffers();
            assert (this.buffers.isEmpty());
        }
        finally {
            ((OutputShop)this.delegate).close();
        }
    }

    private void storeBuffers() throws IOException {
        if (this.isBusy()) {
            return;
        }
        SequentialIOExceptionBuilder<IOException, SequentialIOException> builder = new SequentialIOExceptionBuilder<IOException, SequentialIOException>(IOException.class, SequentialIOException.class);
        Iterator<BufferedEntryOutputStream> i = this.buffers.values().iterator();
        while (i.hasNext()) {
            BufferedEntryOutputStream out = i.next();
            boolean remove = true;
            try {
                remove = out.store(false);
            }
            catch (InputException ex) {
                builder.warn(ex);
            }
            catch (IOException ex) {
                throw (SequentialIOException)builder.fail(ex);
            }
            finally {
                if (!remove) continue;
                i.remove();
            }
        }
        builder.check();
    }

    private class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final IOPool.Entry<?> temp;
        final OutputSocket<? extends AE> output;
        final AE local;
        final InputSocket<Entry> input;
        boolean closed;

        BufferedEntryOutputStream(final IOPool.Entry<?> temp, OutputSocket<? extends AE> output) throws IOException {
            super(temp.getOutputSocket().newOutputStream());
            this.output = output;
            this.local = (FsArchiveEntry)output.getLocalTarget();
            final Entry peer = output.getPeerTarget();
            this.temp = temp;
            class ProxyInput
            extends DecoratingInputSocket<Entry> {
                ProxyInput() {
                    super(entry.getInputSocket());
                }

                @Override
                public Entry getLocalTarget() {
                    return null != peer ? peer : temp;
                }
            }
            this.input = new ProxyInput();
            BufferedEntryOutputStream old = FsMultiplexedOutputShop.this.buffers.put(this.local.getName(), this);
            if (null != old) {
                old.store(true);
            }
        }

        AE getTarget() {
            return this.local;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.delegate.close();
            }
            finally {
                try {
                    Entry src = (Entry)this.input.getLocalTarget();
                    Object dst = this.getTarget();
                    if (-1L == dst.getSize(Entry.Size.DATA)) {
                        dst.setSize(Entry.Size.DATA, src.getSize(Entry.Size.DATA));
                    }
                    for (Entry.Access type : Entry.ALL_ACCESS_SET) {
                        if (-1L != dst.getTime(type)) continue;
                        dst.setTime(type, src.getTime(type));
                    }
                }
                finally {
                    FsMultiplexedOutputShop.this.storeBuffers();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean store(boolean discard) throws IOException {
            if (discard) {
                assert (this.closed) : "broken archive controller!";
            } else if (!this.closed || FsMultiplexedOutputShop.this.isBusy()) {
                return false;
            }
            try {
                if (!discard) {
                    IOSocket.copy(this.input, this.output);
                }
            }
            finally {
                this.temp.release();
            }
            return true;
        }
    }

    private class EntryOutputStream
    extends DecoratingOutputStream {
        boolean closed;

        EntryOutputStream(OutputStream out) {
            super(out);
            FsMultiplexedOutputShop.this.busy = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            FsMultiplexedOutputShop.this.busy = false;
            try {
                this.delegate.close();
            }
            finally {
                FsMultiplexedOutputShop.this.storeBuffers();
            }
        }
    }

    private class BufferedEntriesIterator
    implements Iterator<AE> {
        final Iterator<BufferedEntryOutputStream> i;

        private BufferedEntriesIterator() {
            this.i = FsMultiplexedOutputShop.this.buffers.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public AE next() {
            return this.i.next().getTarget();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

