/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.xml;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.ListOfStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.SetOfStringView;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.EncryptedDictionary;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PasswordEncryptingCiConverter
extends ConfigurationItemConverter {
    private final PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
    private final StringValueConverter converter = new StringValueConverter(this.passwordEncrypter);

    public PasswordEncryptingCiConverter() {
        this.setWriteValidationMessages(true);
    }

    public ConfigurationItem readCi(CiReader reader) {
        ConfigurationItem ci = super.readCi(reader);
        for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: 
                case DATE: 
                case CI: 
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    break;
                }
                case SET_OF_STRING: {
                    Set setOfString = (Set)pd.get(ci);
                    if (setOfString instanceof SetOfStringView) break;
                    pd.set(ci, (Object)SetOfStringView.from(setOfString));
                    break;
                }
                case LIST_OF_STRING: {
                    List listOfString = (List)pd.get(ci);
                    if (listOfString instanceof ListOfStringView) break;
                    pd.set(ci, (Object)ListOfStringView.from(listOfString));
                    break;
                }
                case MAP_STRING_STRING: {
                    Map mapStringString = (Map)pd.get(ci);
                    if (mapStringString instanceof MapStringStringView) break;
                    pd.set(ci, (Object)MapStringStringView.from(mapStringString));
                }
            }
        }
        return ci;
    }

    protected void writeStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        if (propertyDescriptor.isPassword()) {
            writer.valueAsString((Object)this.passwordEncrypter.ensureEncrypted(value.toString()));
        } else {
            super.writeStringProperty(value, propertyDescriptor, writer);
        }
    }

    protected void writeCollectionOfStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        if (value instanceof AbstractStringView) {
            value = Collections2.transform(((AbstractStringView)value).getWrapped(), StringValueConverter.valueToString(this.passwordEncrypter, true));
        }
        super.writeCollectionOfStringProperty(value, propertyDescriptor, writer);
    }

    protected void writeMapStringStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        if (value instanceof MapStringStringView) {
            value = Maps.transformValues(((MapStringStringView)value).getWrapped(), StringValueConverter.valueToString(this.passwordEncrypter, true));
        }
        super.writeMapStringStringProperty(value, propertyDescriptor, writer);
    }

    protected void writeCollectionOfCiProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        Collection cis = (Collection)value;
        ArrayList<String> ids = new ArrayList<String>(cis.size());
        for (ConfigurationItem ci : cis) {
            ids.add(ci.getId());
        }
        writer.ciReferences(ids);
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        if (propertyDescriptor.isPassword()) {
            propertyDescriptor.set(configurationItem, (Object)this.passwordEncrypter.ensureDecrypted(reader.getStringValue()));
        } else {
            super.readStringProperty(configurationItem, propertyDescriptor, reader);
        }
    }

    protected void readCollectionOfStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        AbstractCollection strings;
        AbstractCollection abstractCollection = strings = propertyDescriptor.getKind() == PropertyKind.SET_OF_STRING ? Sets.newHashSet() : Lists.newArrayList();
        while (reader.hasMoreProperties()) {
            reader.moveIntoProperty();
            strings.add(this.converter.convert(reader.getStringValue()));
            reader.moveOutOfProperty();
        }
        AbstractStringView view = propertyDescriptor.getKind() == PropertyKind.SET_OF_STRING ? new SetOfStringView((Set)((Object)strings)) : new ListOfStringView((List)((Object)strings));
        propertyDescriptor.set(configurationItem, (Object)view);
    }

    protected void readMapStringStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        HashMap map = Maps.newHashMap();
        boolean encrypt = configurationItem.getType().equals((Object)Type.valueOf(EncryptedDictionary.class));
        for (Map.Entry entry : reader.getStringMap().entrySet()) {
            map.put(entry.getKey(), this.converter.convert((String)entry.getValue(), encrypt));
        }
        propertyDescriptor.set(configurationItem, (Object)new MapStringStringView(map));
    }
}

