/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.packager.content;

import com.xebialabs.deployit.engine.packager.content.DarContents;
import com.xebialabs.deployit.engine.packager.content.DarMember;
import com.xebialabs.deployit.engine.packager.content.PackagingListener;
import com.xebialabs.deployit.engine.packager.manifest.ManifestBasedManifestWriter;
import com.xebialabs.deployit.engine.packager.manifest.ManifestWriter;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ExternalDarContents
extends DarContents {
    private final PackagingListener listener;
    private List<DarMember> deployables;
    private String version;
    private String applicationName;
    private ManifestWriter manifestWriter = new ManifestBasedManifestWriter();

    public ExternalDarContents(PackagingListener listener, List<DarMember> deployables, String applicationName, String version) {
        this.listener = listener;
        this.deployables = deployables;
        this.applicationName = applicationName;
        this.version = version;
    }

    @Override
    public void fillIn(TFile file) throws IOException {
        this.manifestWriter.addHeader(this.applicationName, this.version);
        for (DarMember deployable : this.deployables) {
            this.listener.println("Add deployable " + deployable);
            Map<String, String> values = deployable.getValues();
            if (!deployable.getTags().isEmpty()) {
                int idx = 0;
                for (String tag : deployable.getTags()) {
                    values.put("tags-EntryValue-" + idx, tag);
                    ++idx;
                }
            }
            this.manifestWriter.addArtifactEntry(deployable.getEntryName(), deployable.getType(), values, deployable.getName());
        }
        this.listener.println(new String(this.manifestWriter.writeTo(new ByteArrayOutputStream()).toByteArray()));
        this.attachManifest(file, this.manifestWriter);
        this.copyArtifactsToDar(this.deployables, file);
    }

    @Override
    public String getPackageName() {
        return String.format("%s-%s.dar", this.applicationName, this.version);
    }

    private void copyArtifactsToDar(List<DarMember> deployables, TFile dar) throws IOException {
        for (DarMember deployable : deployables) {
            if (deployable.getLocation() == null) continue;
            TFile destArtifact = new TFile((File)dar, deployable.getEntryName(), TArchiveDetector.NULL);
            TFile.cp_r((File)deployable.getLocation(), (File)destArtifact, (TArchiveDetector)TArchiveDetector.NULL);
        }
    }
}

