/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.ZipParameters;
import de.schlichtherle.truezip.zip.ZipParametersException;
import de.schlichtherle.truezip.zip.ZipParametersProvider;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class ZipParametersUtils {
    private ZipParametersUtils() {
    }

    static <P extends ZipParameters> P parameters(Class<P> type, @CheckForNull ZipParameters param) throws ZipParametersException {
        while (null != param) {
            if (type.isAssignableFrom(param.getClass())) {
                return (P)param;
            }
            if (!(param instanceof ZipParametersProvider)) break;
            param = ((ZipParametersProvider)param).get(type);
        }
        throw new ZipParametersException("No suitable ZIP parameters available!");
    }
}

