/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.DeployitConfiguration;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.io.Console;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.crypto.SecretKey;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class Recovery {
    private final DeployitOptions options;
    private JackrabbitRepositoryFactoryBean factory;
    private static final Logger logger = LoggerFactory.getLogger(Recovery.class);

    public Recovery(DeployitOptions deployitOptions) {
        this.options = deployitOptions;
        LocalBooter.boot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.displayWarning();
        logger.info("Setting JackRabbit recovery property");
        System.getProperties().setProperty("org.apache.jackrabbit.version.recovery", "true");
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)this.options.getRepositoryKeystorePassword());
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            System.out.println("Could not load the encryption key.");
            return;
        }
        DeployitConfiguration.load();
        Repository repository = this.bootRepository();
        try {
            JcrTemplate jcrTemplate = new JcrTemplate(repository);
            logger.info("Logging into the Jackrabbit Repository");
            jcrTemplate.login();
            jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

                public Object doInJcr(Session session) throws RepositoryException {
                    RawRepositoryImpl rawRepository = new RawRepositoryImpl(session);
                    Recovery.this.recoverNodes(rawRepository);
                    logger.info("Finished recovery of the repository.");
                    session.save();
                    return null;
                }
            });
        }
        finally {
            logger.info("Shutting down the repository.");
            this.factory.destroy();
        }
    }

    private void displayWarning() {
        System.out.println("*** We're going to attempt to run a recovery process on your repository. ***");
        System.out.println("***    It is HIGHLY recommended to make a backup before you proceed.     ***");
        System.out.println("***                 Are you sure you wish to continue?                   ***");
        Console console = System.console();
        if (console == null) {
            throw new IllegalStateException("Not running in interactive mode, please run recovery from a console. Quitting now.");
        }
        String s = console.readLine("Please enter 'yes' if you wish to continue. [no] > ", new Object[0]);
        if (!s.equalsIgnoreCase("yes")) {
            System.exit(99);
        }
    }

    private void recoverNodes(RawRepositoryImpl rawRepository) throws RepositoryException {
        Collection allTypes = Collections2.transform((Collection)DescriptorRegistry.getDescriptors(), (Function)new Function<Descriptor, Type>(){

            public Type apply(Descriptor input) {
                return input.getType();
            }
        });
        for (Type type : allTypes) {
            logger.debug("Checking nodes of type [{}]", (Object)type);
            List nodesByType = rawRepository.findNodesByType(type);
            this.detectAndRecoverBrokenNodes(nodesByType);
        }
    }

    private void detectAndRecoverBrokenNodes(List<Node> nodesByType) throws RepositoryException {
        for (Node node : nodesByType) {
            logger.debug("Inspecting node [{}]", (Object)node.getName());
            ArrayList strings = Lists.newArrayList((Object[])new String[]{"{http://www.jcp.org/jcr/mix/1.0}referenceable", "{http://www.jcp.org/jcr/mix/1.0}versionable"});
            for (String mixin : strings) {
                this.checkAndRecoverMixin(node, mixin);
            }
        }
    }

    private void checkAndRecoverMixin(Node node, String mixin) throws RepositoryException {
        if (!node.isNodeType(mixin)) {
            logger.info("Adding missing mixin [{}] to node [{}]", (Object)mixin, (Object)node.getName());
            node.addMixin(mixin);
        }
    }

    private Repository bootRepository() {
        try {
            this.factory = new JackrabbitRepositoryFactoryBean();
            this.factory.setConfiguration((Resource)new ClassPathResource("jackrabbit-repository.xml"));
            this.factory.setHomeDir((Resource)new FileSystemResource(DeployitConfiguration.getInstance().getJcrRepositoryPath()));
            this.factory.afterPropertiesSet();
            return this.factory.getObject();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

