/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.ssh.SshSudoFile;
import java.io.IOException;
import java.io.OutputStream;

class SshSudoOutputStream
extends OutputStream {
    private SshSudoFile destFile;
    private OverthereFile tempFile;
    private OutputStream tempFileOutputStream;

    public SshSudoOutputStream(SshSudoFile destFile, OverthereFile tempFile) {
        this.destFile = destFile;
        this.tempFile = tempFile;
        this.tempFileOutputStream = tempFile.getOutputStream();
    }

    @Override
    public void write(int b) throws IOException {
        this.tempFileOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.tempFileOutputStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.tempFileOutputStream.write(b);
    }

    @Override
    public void close() throws IOException {
        this.tempFileOutputStream.close();
        this.destFile.copyFromTempFile(this.tempFile);
    }
}

