/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

@Metadata(description="A deployment of an application package or a deployable artifact to a middleware CI or an environment.")
public class DeployedApplication
extends BaseConfigurationItem {
    @Property(description="The package that has been deployed to the environment")
    private Version version;
    @Property(asContainment=true)
    private Environment environment;
    @Property(description="The deployed items that have been deployed to the environment")
    private Set<Deployed> deployeds = Sets.newHashSet();
    @Property(description="The orchestrator that is used to deploy the application", defaultValue="default")
    private String orchestrator;
    @Property(description="If set to true, the orchestrator will generate a parallel plan for each container", required=false, defaultValue="false")
    private boolean parallelByContainer;

    public DeployedApplication() {
    }

    public DeployedApplication(Version version, Environment environment) {
        this.version = version;
        this.environment = environment;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Set<Deployed> getDeployeds() {
        return this.deployeds;
    }

    public void setDeployeds(Set<Deployed> deployeds) {
        this.deployeds = deployeds;
    }

    public void addDeployed(Deployed deployed) {
        this.deployeds.add(deployed);
    }

    public void addDeployeds(Deployed ... deployeds) {
        this.deployeds.addAll(Arrays.asList(deployeds));
    }

    public void addDeployeds(Collection<Deployed> deployeds) {
        this.deployeds.addAll(deployeds);
    }

    public String getOrchestrator() {
        return this.orchestrator;
    }

    public void setOrchestrator(String orchestrator) {
        this.orchestrator = orchestrator;
    }

    public boolean isParallelByContainer() {
        return this.parallelByContainer;
    }

    public void setParallelByContainer(boolean parallelByContainer) {
        this.parallelByContainer = parallelByContainer;
    }
}

