/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.routing.Broadcast;
import akka.routing.ConsistentActorRef;
import akka.routing.ConsistentHash;
import akka.routing.ConsistentHash$;
import akka.routing.ConsistentHashingLike;
import akka.routing.ConsistentHashingRouter;
import akka.routing.Destination;
import akka.routing.RouteeProvider;
import akka.routing.RouterConfig;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.util.control.NonFatal$;

public abstract class ConsistentHashingLike$class {
    public static PartialFunction createRoute(ConsistentHashingLike $this, RouteeProvider routeeProvider) {
        if (((RouterConfig)((Object)$this)).resizer().isEmpty()) {
            if ($this.routees().isEmpty()) {
                routeeProvider.createRoutees($this.nrOfInstances());
            } else {
                routeeProvider.registerRouteesFor($this.routees());
            }
        }
        LoggingAdapter log = Logging$.MODULE$.apply(routeeProvider.context().system(), routeeProvider.context().self(), LogSource$.MODULE$.fromActorRef());
        Address selfAddress = ((ExtendedActorSystem)routeeProvider.context().system()).provider().getDefaultAddress();
        int vnodes = $this.virtualNodesFactor() == 0 ? routeeProvider.context().system().settings().DefaultVirtualNodesFactor() : $this.virtualNodesFactor();
        AtomicReference<Tuple2> consistentHashRef = new AtomicReference<Tuple2>(new Tuple2(null, null));
        ConsistentHashingLike$class.updateConsistentHash$1($this, selfAddress, vnodes, consistentHashRef, routeeProvider);
        return new Serializable($this, log, selfAddress, vnodes, consistentHashRef, routeeProvider){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsistentHashingLike $outer;
            private final LoggingAdapter log$1;
            private final Address selfAddress$1;
            private final int vnodes$1;
            private final AtomicReference consistentHashRef$1;
            private final RouteeProvider routeeProvider$1;

            public final <A1 extends Tuple2<ActorRef, Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                List list;
                A1 A1 = x2;
                if (A1 != null) {
                    List list2;
                    ActorRef sender = (ActorRef)A1._1();
                    Object message = A1._2();
                    Object object = message;
                    if (object instanceof Broadcast) {
                        list2 = ((RouterConfig)((Object)this.$outer)).toAll(sender, (Iterable<ActorRef>)this.routeeProvider$1.routees());
                    } else if (this.$outer.hashMapping().isDefinedAt(message)) {
                        list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Destination[]{new Destination(sender, ConsistentHashingLike$class.target$1(this.$outer, this.$outer.hashMapping().apply(message), this.log$1, this.selfAddress$1, this.vnodes$1, this.consistentHashRef$1, this.routeeProvider$1))}));
                    } else if (object instanceof ConsistentHashingRouter.ConsistentHashable) {
                        ConsistentHashingRouter.ConsistentHashable consistentHashable = (ConsistentHashingRouter.ConsistentHashable)object;
                        list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Destination[]{new Destination(sender, ConsistentHashingLike$class.target$1(this.$outer, consistentHashable.consistentHashKey(), this.log$1, this.selfAddress$1, this.vnodes$1, this.consistentHashRef$1, this.routeeProvider$1))}));
                    } else {
                        this.log$1.warning("Message [{}] must be handled by hashMapping, or implement [{}] or be wrapped in [{}]", message.getClass().getName(), ConsistentHashingRouter.ConsistentHashable.class.getName(), ConsistentHashingRouter.ConsistentHashableEnvelope.class.getName());
                        list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Destination[]{new Destination(sender, this.routeeProvider$1.context().system().deadLetters())}));
                    }
                    list = list2;
                } else {
                    list = function1.apply(x2);
                }
                return (B1)list;
            }

            public final boolean isDefinedAt(Tuple2<ActorRef, Object> x2) {
                Tuple2<ActorRef, Object> tuple2 = x2;
                boolean bl = tuple2 != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$1 = log$1;
                this.selfAddress$1 = selfAddress$1;
                this.vnodes$1 = vnodes$1;
                this.consistentHashRef$1 = consistentHashRef$1;
                this.routeeProvider$1 = routeeProvider$1;
            }
        };
    }

    private static final ConsistentHash updateConsistentHash$1(ConsistentHashingLike $this, Address selfAddress$1, int vnodes$1, AtomicReference consistentHashRef$1, RouteeProvider routeeProvider$1) {
        Tuple2 oldConsistentHashTuple = (Tuple2)consistentHashRef$1.get();
        Tuple2 tuple2 = oldConsistentHashTuple;
        if (tuple2 != null) {
            ConsistentHash consistentHash;
            Tuple2 tuple22;
            IndexedSeq oldConsistentHashRoutees = (IndexedSeq)tuple2._1();
            ConsistentHash oldConsistentHash = (ConsistentHash)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)oldConsistentHashRoutees, (Object)oldConsistentHash);
            IndexedSeq oldConsistentHashRoutees2 = (IndexedSeq)tuple23._1();
            ConsistentHash oldConsistentHash2 = (ConsistentHash)tuple23._2();
            scala.collection.immutable.IndexedSeq currentRoutees = (scala.collection.immutable.IndexedSeq)routeeProvider$1.routees().map((Function1)new Serializable($this, selfAddress$1){
                public static final long serialVersionUID = 0L;
                private final Address selfAddress$1;

                public final ConsistentActorRef apply(ActorRef x$3) {
                    return new ConsistentActorRef(x$3, this.selfAddress$1);
                }
                {
                    this.selfAddress$1 = selfAddress$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            if (currentRoutees != oldConsistentHashRoutees2) {
                scala.collection.immutable.IndexedSeq indexedSeq = currentRoutees;
                IndexedSeq indexedSeq2 = oldConsistentHashRoutees2;
                ConsistentHash consistentHash2 = !(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null) ? oldConsistentHash2 : ConsistentHash$.MODULE$.apply(currentRoutees, vnodes$1, ClassTag$.MODULE$.apply(ConsistentActorRef.class));
                consistentHashRef$1.compareAndSet(oldConsistentHashTuple, new Tuple2((Object)currentRoutees, consistentHash2));
                consistentHash = consistentHash2;
            } else {
                consistentHash = oldConsistentHash2;
            }
            return consistentHash;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final ActorRef target$1(ConsistentHashingLike $this, Object hashData, LoggingAdapter log$1, Address selfAddress$1, int vnodes$1, AtomicReference consistentHashRef$1, RouteeProvider routeeProvider$1) {
        ActorRef actorRef;
        block6: {
            try {
                Object object;
                block10: {
                    ActorRef actorRef2;
                    block8: {
                        ConsistentHash currentConsistenHash;
                        block9: {
                            block7: {
                                currentConsistenHash = ConsistentHashingLike$class.updateConsistentHash$1($this, selfAddress$1, vnodes$1, consistentHashRef$1, routeeProvider$1);
                                if (currentConsistenHash.isEmpty()) {
                                    actorRef = routeeProvider$1.context().system().deadLetters();
                                    break block6;
                                }
                                object = hashData;
                                if (!(object instanceof byte[])) break block7;
                                byte[] byArray = (byte[])object;
                                actorRef2 = ((ConsistentActorRef)currentConsistenHash.nodeFor(byArray)).actorRef();
                                break block8;
                            }
                            if (!(object instanceof String)) break block9;
                            String string = (String)object;
                            actorRef2 = ((ConsistentActorRef)currentConsistenHash.nodeFor(string)).actorRef();
                            break block8;
                        }
                        if (!(object instanceof Object)) break block10;
                        Object object2 = object;
                        actorRef2 = ((ConsistentActorRef)currentConsistenHash.nodeFor((byte[])((Serialization)SerializationExtension$.MODULE$.apply(routeeProvider$1.context().system())).serialize(object2).get())).actorRef();
                    }
                    actorRef = actorRef2;
                    break block6;
                }
                throw new MatchError(object);
            }
            catch (Throwable throwable) {
                ActorRef actorRef3;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                log$1.warning("Couldn't route message with consistent hash key [{}] due to [{}]", hashData, e.getMessage());
                actorRef = actorRef3 = routeeProvider$1.context().system().deadLetters();
            }
        }
        return actorRef;
    }

    public static void $init$(ConsistentHashingLike $this) {
    }
}

