/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.PoisonPill$;
import akka.actor.Props;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.japi.Util$;
import akka.routing.Resizer;
import akka.routing.RoutedActorCell;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u001d\u0011aBU8vi\u0016,\u0007K]8wS\u0012,'O\u0003\u0002\u0004\t\u00059!o\\;uS:<'\"A\u0003\u0002\t\u0005\\7.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001f\u0001\u0011)\u0019!C\u0001!\u000591m\u001c8uKb$X#A\t\u0011\u0005I)R\"A\n\u000b\u0005Q!\u0011!B1di>\u0014\u0018B\u0001\f\u0014\u00051\t5\r^8s\u0007>tG/\u001a=u\u0011!A\u0002A!A!\u0002\u0013\t\u0012\u0001C2p]R,\u0007\u0010\u001e\u0011\t\u0011i\u0001!Q1A\u0005\u0002m\t1B]8vi\u0016,\u0007K]8qgV\tA\u0004\u0005\u0002\u0013;%\u0011ad\u0005\u0002\u0006!J|\u0007o\u001d\u0005\tA\u0001\u0011\t\u0011)A\u00059\u0005a!o\\;uK\u0016\u0004&o\u001c9tA!A!\u0005\u0001BC\u0002\u0013\u00051%A\u0004sKNL'0\u001a:\u0016\u0003\u0011\u00022!C\u0013(\u0013\t1#B\u0001\u0004PaRLwN\u001c\t\u0003Q%j\u0011AA\u0005\u0003U\t\u0011qAU3tSj,'\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003%\u0003!\u0011Xm]5{KJ\u0004\u0003\"\u0002\u0018\u0001\t\u0003y\u0013A\u0002\u001fj]&$h\b\u0006\u00031cI\u001a\u0004C\u0001\u0015\u0001\u0011\u0015yQ\u00061\u0001\u0012\u0011\u0015QR\u00061\u0001\u001d\u0011\u0015\u0011S\u00061\u0001%\u0011\u0015)\u0004\u0001\"\u00017\u0003=\u0011XmZ5ti\u0016\u0014(k\\;uK\u0016\u001cHCA\u001c;!\tI\u0001(\u0003\u0002:\u0015\t!QK\\5u\u0011\u0015YD\u00071\u0001=\u0003\u001d\u0011x.\u001e;fKN\u00042!\u0010\"E\u001b\u0005q$BA A\u0003%IW.\\;uC\ndWM\u0003\u0002B\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\rs$\u0001C%uKJ\f'\r\\3\u0011\u0005I)\u0015B\u0001$\u0014\u0005!\t5\r^8s%\u00164\u0007\"B\u001b\u0001\t\u0003AECA\u001cJ\u0011\u0015Yt\t1\u0001K!\rY\u0005\u000bR\u0007\u0002\u0019*\u0011QJT\u0001\u0005Y\u0006twMC\u0001P\u0003\u0011Q\u0017M^1\n\u0005\rc\u0005\"\u0002*\u0001\t\u0003\u0019\u0016!E;oe\u0016<\u0017n\u001d;feJ{W\u000f^3fgR\u0011q\u0007\u0016\u0005\u0006wE\u0003\r\u0001\u0010\u0005\u0006%\u0002!\tA\u0016\u000b\u0003o]CQaO+A\u0002)CQ!\u0017\u0001\u0005\u0002i\u000b!C]3hSN$XM\u001d*pkR,Wm\u001d$peR\u0011qg\u0017\u0005\u00069b\u0003\r!X\u0001\u0006a\u0006$\bn\u001d\t\u0004{\ts\u0006CA0c\u001d\tI\u0001-\u0003\u0002b\u0015\u00051\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\t'\u0002C\u0003Z\u0001\u0011\u0005a\r\u0006\u00028O\")A,\u001aa\u0001QB\u00191\n\u00150\t\u000b)\u0004A\u0011A6\u0002\u001b\r\u0014X-\u0019;f%>,H/Z3t)\t9D\u000eC\u0003nS\u0002\u0007a.A\u0007oe>3\u0017J\\:uC:\u001cWm\u001d\t\u0003\u0013=L!\u0001\u001d\u0006\u0003\u0007%sG\u000fC\u0003s\u0001\u0011\u00051/A\u0007sK6|g/\u001a*pkR,Wm\u001d\u000b\u0004oQ,\b\"B7r\u0001\u0004q\u0007\"\u0002<r\u0001\u00049\u0018!C:u_B$U\r\\1z!\tAX0D\u0001z\u0015\tQ80\u0001\u0005ekJ\fG/[8o\u0015\ta(\"\u0001\u0006d_:\u001cWO\u001d:f]RL!A`=\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"9\u0011\u0011\u0001\u0001\u0005\u0012\u0005\r\u0011a\u00033fY\u0006LX\rZ*u_B$raNA\u0003\u0003\u001f\t\u0019\u0002C\u0004\u0002\b}\u0004\r!!\u0003\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bc\u0001\n\u0002\f%\u0019\u0011QB\n\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\bBBA\t\u007f\u0002\u0007A(A\u0004bE\u0006tGm\u001c8\t\u000bY|\b\u0019A<\t\rm\u0002A\u0011AA\f+\t\tI\u0002\u0005\u0003>\u00037!\u0015bAA\u000f}\tQ\u0011J\u001c3fq\u0016$7+Z9\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\u0005Qq-\u001a;S_V$X-Z:\u0015\u0005\u0005\u0015\u0002#BA\u0014\u0003[!UBAA\u0015\u0015\r\tYCT\u0001\u0005kRLG.\u0003\u0003\u00020\u0005%\"\u0001\u0002'jgRDq!a\r\u0001\t\u0013\t)$\u0001\u0006s_V$X\rZ\"fY2,\"!a\u000e\u0011\u0007!\nI$C\u0002\u0002<\t\u0011qBU8vi\u0016$\u0017i\u0019;pe\u000e+G\u000e\u001c")
public class RouteeProvider {
    private final ActorContext context;
    private final Props routeeProps;
    private final Option<Resizer> resizer;

    public ActorContext context() {
        return this.context;
    }

    public Props routeeProps() {
        return this.routeeProps;
    }

    public Option<Resizer> resizer() {
        return this.resizer;
    }

    public void registerRoutees(Iterable<ActorRef> routees) {
        this.routedCell().addRoutees(routees);
    }

    public void registerRoutees(java.lang.Iterable<ActorRef> routees) {
        this.registerRoutees((Iterable<ActorRef>)Util$.MODULE$.immutableSeq(routees));
    }

    public void unregisterRoutees(Iterable<ActorRef> routees) {
        this.routedCell().removeRoutees(routees);
    }

    public void unregisterRoutees(java.lang.Iterable<ActorRef> routees) {
        this.unregisterRoutees((Iterable<ActorRef>)Util$.MODULE$.immutableSeq(routees));
    }

    public void registerRouteesFor(Iterable<String> paths) {
        this.registerRoutees((Iterable<ActorRef>)((Iterable)paths.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RouteeProvider $outer;

            public final ActorRef apply(String x$4) {
                return this.$outer.context().actorFor(x$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())));
    }

    public void registerRouteesFor(java.lang.Iterable<String> paths) {
        this.registerRouteesFor((Iterable<String>)Util$.MODULE$.immutableSeq(paths));
    }

    public void createRoutees(int nrOfInstances) {
        if (nrOfInstances <= 0) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Must specify nrOfInstances or routees for [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.context().self().path().toString()})));
        }
        this.registerRoutees((Iterable<ActorRef>)((Iterable)IndexedSeq$.MODULE$.fill(nrOfInstances, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RouteeProvider $outer;

            public final ActorRef apply() {
                return this.$outer.context().actorOf(this.$outer.routeeProps());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })));
    }

    public void removeRoutees(int nrOfInstances, FiniteDuration stopDelay) {
        if (nrOfInstances <= 0) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Expected positive nrOfInstances, got [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nrOfInstances)})));
        }
        if (nrOfInstances > 0) {
            IndexedSeq<ActorRef> currentRoutees = this.routees();
            IndexedSeq abandon = (IndexedSeq)currentRoutees.drop(currentRoutees.length() - nrOfInstances);
            this.unregisterRoutees((Iterable<ActorRef>)abandon);
            this.delayedStop(this.context().system().scheduler(), (Iterable<ActorRef>)abandon, stopDelay);
        }
    }

    public void delayedStop(Scheduler scheduler, Iterable<ActorRef> abandon, FiniteDuration stopDelay) {
        if (abandon.nonEmpty()) {
            if (stopDelay.$less$eq((Object)Duration$.MODULE$.Zero())) {
                abandon.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorRef x$5) {
                        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(x$5);
                        PoisonPill$ x$19 = PoisonPill$.MODULE$;
                        ActorRef x$20 = qual$2.$bang$default$2(x$19);
                        qual$2.$bang(x$19, x$20);
                    }
                });
            } else {
                IndexedSeq localAbandon = abandon.toIndexedSeq();
                scheduler.scheduleOnce(stopDelay, (Function0<BoxedUnit>)new Serializable(this, localAbandon){
                    public static final long serialVersionUID = 0L;
                    private final IndexedSeq localAbandon$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.localAbandon$1.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(ActorRef x$6) {
                                ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(x$6);
                                PoisonPill$ x$21 = PoisonPill$.MODULE$;
                                ActorRef x$22 = qual$3.$bang$default$2(x$21);
                                qual$3.$bang(x$21, x$22);
                            }
                        });
                    }
                    {
                        this.localAbandon$1 = localAbandon$1;
                    }
                }, this.context().dispatcher());
            }
        }
    }

    public IndexedSeq<ActorRef> routees() {
        return this.routedCell().routees();
    }

    public List<ActorRef> getRoutees() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.routees()).asJava();
    }

    private RoutedActorCell routedCell() {
        return (RoutedActorCell)this.context();
    }

    public RouteeProvider(ActorContext context, Props routeeProps, Option<Resizer> resizer) {
        this.context = context;
        this.routeeProps = routeeProps;
        this.resizer = resizer;
    }
}

