/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.gc;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.Blocks;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.StepBlock;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.gc.DefaultGarbageCollectionStep;
import com.xebialabs.deployit.service.gc.GarbageCollectionSemaphore;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GarbageCollectionServiceImpl
implements GarbageCollectionService {
    private IEngine engine;
    private static final Logger logger = LoggerFactory.getLogger(GarbageCollectionServiceImpl.class);

    @Autowired
    public GarbageCollectionServiceImpl(IEngine engine) {
        this.engine = engine;
    }

    public void runGarbageCollector() {
        if (!GarbageCollectionSemaphore.claimProcessSlot()) {
            logger.warn("Not starting new garbage collector since garbage collection already in progress");
            return;
        }
        DefaultGarbageCollectionStep garbageCollectionStep = new DefaultGarbageCollectionStep();
        StepBlock stepBlock = Blocks.steps((String)"0", (List)Lists.newArrayList((Object[])new TaskStep[]{new TaskStep((Step)garbageCollectionStep)}));
        TaskSpecification spec = new TaskSpecification("Garbage collection", Permissions.getAuthentication().getName(), (Block)stepBlock, null, false, false);
        spec.getListeners().add(new GarbageCollectionSemaphore());
        String id = this.engine.register(spec);
        this.engine.execute(id);
    }
}

