/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState2;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedStep;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrArchivedTaskSearchQueryBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.QueryObjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrTaskArchive
implements Archive {
    public static final String ENVIRONMENTS_ROOT = "Environments/";
    public static final String CONFIGURATION_ROOT = "Configuration/";
    static final String STATE = "state";
    static final String START_DATE = "startDate";
    static final String COMPLETION_DATE = "completionDate";
    static final String LAST_MODIFICATION_DATE = "lastModificationDate";
    static final String NR_OF_STEPS = "nrOfSteps";
    static final String CURRENT_STEP_NR = "currentStepNr";
    static final String OWNING_USER = "ownerUser";
    static final String FAILURE_COUNT = "failureCount";
    static final String LOG = "log";
    static final String DESCRIPTION = "description";
    static final String APPLICATION = "application";
    static final String VERSION = "version";
    static final String ENVIRONMENT_NAME = "environment";
    static final String ENVIRONMENT_ID = "environment_id";
    static final String DEPLOYMENT_TYPE = "deploymentType";
    static final String CLOUD_ENVIRONMENT_ID = "cloudEnvironmentId";
    static final String CLOUD_ENVIRONMENT_TEMPLATE_ID = "cloudEnvironmentTemplateId";
    static final String CLOUD_OPERATION = "cloudOperation";
    public static final String DESTROY_CONTROL_TASK_NAME = "destroy";
    public static final String INSTANTIATE_CONTROL_TASK_NAME = "instantiate";
    private final JcrTemplate jcrTemplate;
    private static final Pattern qualifiedTaskIdPattern = Pattern.compile("^(.*)/(.*)/(.*)/(.*)$");
    private final Set<String> EXCLUDE_SPECIAL_ENV_TASK_NAMES = Sets.newHashSet((Object[])new String[]{"Environments/" + (Object)((Object)TaskType.INSPECTION), "Environments/" + (Object)((Object)TaskType.CONTROL), "Environments/rep:policy"});
    private static final Logger logger = LoggerFactory.getLogger(JcrTaskArchive.class);

    @Autowired
    public JcrTaskArchive(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public void archive(TaskWithSteps task) {
        logger.info("Archiving task [{}] with metadata [{}]", (Object)task.getId(), (Object)task.getMetadata());
        if (JcrTaskArchive.isCloudTask(task)) {
            this.saveCloudTask(task);
        } else if (JcrTaskArchive.isDeploymentTask(task)) {
            this.saveDeploymentTask(task);
        } else {
            this.saveTask(task);
        }
    }

    private void saveTask(final TaskWithSteps task) {
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<String>(){

            public String doInJcr(Session session) throws RepositoryException {
                Node jcrTaskNode = JcrTaskArchive.createTaskNode(task, JcrTaskArchive.getTasksRootNode(session));
                JcrTaskArchive.fillTaskNode(jcrTaskNode, task);
                session.save();
                return null;
            }
        });
    }

    private void saveCloudTask(final TaskWithSteps task) {
        JcrTaskArchive.checkCloudTask(task);
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<String>(){

            public String doInJcr(Session session) throws RepositoryException {
                Node jcrTaskNode = JcrTaskArchive.createTaskNode(task, JcrTaskArchive.getTasksRootNode(session));
                JcrTaskArchive.fillCloudTaskNode(jcrTaskNode, task);
                session.save();
                return null;
            }
        });
    }

    private void saveDeploymentTask(final TaskWithSteps task) {
        JcrTaskArchive.checkDeploymentTask(task);
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<String>(){

            public String doInJcr(Session session) throws RepositoryException {
                Node jcrTaskNode = JcrTaskArchive.createDeploymentTaskNode(task, JcrTaskArchive.getTasksRootNode(session));
                JcrTaskArchive.fillDeploymentTaskNode(jcrTaskNode, task);
                session.save();
                return null;
            }
        });
    }

    private static Node createTaskNode(TaskWithSteps task, Node tasksRootNode) throws RepositoryException {
        Node taskType = JcrUtils.getOrCreateChild((Node)tasksRootNode, (String)TaskMetadata.getMetadata(task, "taskType"));
        Node node = taskType.addNode(task.getId());
        node.addMixin("deployit:task");
        return node;
    }

    private static Node createDeploymentTaskNode(TaskWithSteps task, Node tasksRootNode) throws RepositoryException {
        Node envNode = JcrUtils.getOrCreateChild((Node)tasksRootNode, (String)JcrTaskArchive.encodeEnvironmentId(TaskMetadata.getMetadata(task, ENVIRONMENT_ID)));
        Node appNode = JcrUtils.getOrCreateChild((Node)envNode, (String)TaskMetadata.getMetadata(task, APPLICATION));
        Node verNode = JcrUtils.getOrCreateChild((Node)appNode, (String)TaskMetadata.getMetadata(task, VERSION));
        Node node = verNode.addNode(task.getId());
        node.addMixin("deployit:task");
        return node;
    }

    private static void checkCloudTask(TaskWithSteps task) {
        String operation = TaskMetadata.getMetadata(task, CLOUD_OPERATION);
        Preconditions.checkState((!Strings.nullToEmpty((String)operation).isEmpty() ? 1 : 0) != 0, (Object)"cloudOperation in provisioning task must be set");
        Preconditions.checkState((operation.equals(INSTANTIATE_CONTROL_TASK_NAME) || operation.equals(DESTROY_CONTROL_TASK_NAME) ? 1 : 0) != 0, (Object)"cloudOperation in provisioning task must be [instantiate|destroy]");
        Preconditions.checkState((!Strings.nullToEmpty((String)TaskMetadata.getMetadata(task, CLOUD_ENVIRONMENT_ID)).isEmpty() ? 1 : 0) != 0, (Object)"cloudEnvironmentId in provisioning task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)TaskMetadata.getMetadata(task, CLOUD_ENVIRONMENT_TEMPLATE_ID)).isEmpty() ? 1 : 0) != 0, (Object)"cloudEnvironmentTemplateId in provisioning task must be set");
    }

    private static void checkDeploymentTask(TaskWithSteps task) {
        Preconditions.checkState((!Strings.nullToEmpty((String)TaskMetadata.getMetadata(task, APPLICATION)).isEmpty() ? 1 : 0) != 0, (Object)"applicationName in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)TaskMetadata.getMetadata(task, VERSION)).isEmpty() ? 1 : 0) != 0, (Object)"applicationVersion in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)TaskMetadata.getMetadata(task, ENVIRONMENT_NAME)).isEmpty() ? 1 : 0) != 0, (Object)"environment in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)TaskMetadata.getMetadata(task, ENVIRONMENT_ID)).isEmpty() ? 1 : 0) != 0, (Object)"environment_id in deployment task must be set");
    }

    static String encodeEnvironmentId(String id) {
        return JcrTaskArchive.encodeId(ENVIRONMENTS_ROOT, id);
    }

    static String decodeEnvironmentId(String id) {
        return JcrTaskArchive.decodeId(ENVIRONMENTS_ROOT, id);
    }

    static String encodeConfigurationId(String id) {
        return JcrTaskArchive.encodeId(CONFIGURATION_ROOT, id);
    }

    static String decodeConfigurationId(String id) {
        return JcrTaskArchive.decodeId(CONFIGURATION_ROOT, id);
    }

    static String encodeId(String prefix, String id) {
        if (id.startsWith(prefix)) {
            id = id.substring(prefix.length());
        }
        return id.replace("/", "$#");
    }

    static String decodeId(String prefix, String id) {
        if (!(id = id.replace("$#", "/")).startsWith(prefix)) {
            return prefix + id;
        }
        return id;
    }

    private static void fillDeploymentTaskNode(Node taskNode, TaskWithSteps task) throws RepositoryException {
        JcrTaskArchive.fillTaskNode(taskNode, task);
        taskNode.setProperty(APPLICATION, TaskMetadata.getMetadata(task, APPLICATION));
        taskNode.setProperty(VERSION, TaskMetadata.getMetadata(task, VERSION));
        taskNode.setProperty(ENVIRONMENT_NAME, TaskMetadata.getMetadata(task, ENVIRONMENT_NAME));
        taskNode.setProperty(ENVIRONMENT_ID, JcrTaskArchive.encodeEnvironmentId(TaskMetadata.getMetadata(task, ENVIRONMENT_ID)));
    }

    private static void fillCloudTaskNode(Node taskNode, TaskWithSteps task) throws RepositoryException {
        JcrTaskArchive.fillTaskNode(taskNode, task);
        taskNode.setProperty(CLOUD_OPERATION, TaskMetadata.getMetadata(task, CLOUD_OPERATION));
        taskNode.setProperty(CLOUD_ENVIRONMENT_ID, JcrTaskArchive.encodeEnvironmentId(TaskMetadata.getMetadata(task, CLOUD_ENVIRONMENT_ID)));
        taskNode.setProperty(CLOUD_ENVIRONMENT_TEMPLATE_ID, JcrTaskArchive.encodeConfigurationId(TaskMetadata.getMetadata(task, CLOUD_ENVIRONMENT_TEMPLATE_ID)));
    }

    private static void fillTaskNode(Node taskNode, TaskWithSteps task) throws RepositoryException {
        taskNode.setProperty("$id", task.getId());
        taskNode.setProperty(STATE, task.getState2().name());
        taskNode.setProperty(START_DATE, (Calendar)task.getStartDate().toGregorianCalendar());
        taskNode.setProperty(COMPLETION_DATE, (Calendar)task.getCompletionDate().toGregorianCalendar());
        taskNode.setProperty(CURRENT_STEP_NR, (long)task.getCurrentStepNr());
        taskNode.setProperty(NR_OF_STEPS, (long)task.getNrSteps());
        taskNode.setProperty(OWNING_USER, task.getOwner());
        taskNode.setProperty(FAILURE_COUNT, (long)task.getFailureCount());
        taskNode.setProperty(DEPLOYMENT_TYPE, TaskMetadata.getMetadata(task, "taskType"));
        int nr = 1;
        for (StepState step : task.getSteps()) {
            Node stepNode = taskNode.addNode("step" + nr++);
            stepNode.setProperty(DESCRIPTION, step.getDescription());
            stepNode.setProperty(STATE, step.getState().name());
            stepNode.setProperty(START_DATE, step.getStartDate() == null ? null : step.getStartDate().toGregorianCalendar());
            stepNode.setProperty(COMPLETION_DATE, step.getCompletionDate() == null ? null : step.getCompletionDate().toGregorianCalendar());
            stepNode.setProperty(FAILURE_COUNT, (long)step.getFailureCount());
            stepNode.setProperty(LOG, step.getLog());
        }
    }

    private static boolean isDeploymentTask(TaskWithSteps task) {
        return EnumSet.of(TaskType.ROLLBACK, TaskType.INITIAL, TaskType.UPGRADE, TaskType.UNDEPLOY).contains((Object)TaskType.valueOf(TaskMetadata.getMetadata(task, "taskType")));
    }

    private static boolean isCloudTask(TaskWithSteps task) {
        return EnumSet.of(TaskType.CONTROL).contains((Object)TaskType.valueOf(TaskMetadata.getMetadata(task, "taskType"))) && TaskMetadata.metadataContainsKey(task, CLOUD_OPERATION) && (INSTANTIATE_CONTROL_TASK_NAME.equals(TaskMetadata.getMetadata(task, CLOUD_OPERATION)) || DESTROY_CONTROL_TASK_NAME.equals(TaskMetadata.getMetadata(task, CLOUD_OPERATION)));
    }

    public TaskWithSteps getTask(String taskId) {
        Matcher matcher = qualifiedTaskIdPattern.matcher(taskId);
        if (matcher.matches()) {
            String internalId = JcrTaskArchive.encodeEnvironmentId(matcher.group(1)) + "/" + matcher.group(2) + "/" + matcher.group(3) + "/" + matcher.group(4);
            return this.getTaskUsingFullyQualifiedPath(internalId);
        }
        return this.getTaskUsingUuid(taskId);
    }

    private TaskWithSteps getTaskUsingFullyQualifiedPath(final String fullyQualifiedPath) {
        return (TaskWithSteps)this.jcrTemplate.execute((JcrCallback)new JcrCallback<ArchivedTask>(){

            public ArchivedTask doInJcr(Session session) throws RepositoryException {
                try {
                    Node tasksNode = JcrTaskArchive.getTasksRootNode(session);
                    Node taskNode = tasksNode.getNode(fullyQualifiedPath);
                    ArchivedTask task = JcrTaskArchive.toTaskWithoutSteps(taskNode);
                    if (task == null) {
                        throw new NotFoundException("Cannot load task " + fullyQualifiedPath + " because that object with that id is not a task", new Object[0]);
                    }
                    task.setSteps(JcrTaskArchive.getSteps(taskNode));
                    return task;
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Cannot load task " + fullyQualifiedPath + " because it does not exist", new Object[0]);
                }
            }
        });
    }

    private TaskWithSteps getTaskUsingUuid(String taskUuid) {
        ArchivedTaskSearchParameters taskSearch = new ArchivedTaskSearchParameters();
        taskSearch.withUniqueId(taskUuid);
        Collection<ArchivedTask> deploymentTaskInfos = this.searchTasks(taskSearch);
        if (deploymentTaskInfos.size() == 1) {
            return deploymentTaskInfos.iterator().next();
        }
        if (deploymentTaskInfos.isEmpty()) {
            throw new TaskNotFoundException("archive", taskUuid);
        }
        throw new NotFoundException("Cannot load task " + taskUuid + " because there are multiple tasks with same id. " + deploymentTaskInfos, new Object[0]);
    }

    private static ArchivedTask toTaskWithoutSteps(Node taskNode) throws RepositoryException {
        if (!taskNode.isNodeType("deployit:task")) {
            return null;
        }
        ArchivedTask task = new ArchivedTask();
        task.setId(JcrUtils.getProperty((Node)taskNode, (String)"$id"));
        TaskMetadata.putMetadata(task, "taskType", JcrUtils.getProperty((Node)taskNode, (String)DEPLOYMENT_TYPE));
        task.setState2(TaskExecutionState2.valueOf((String)JcrUtils.getProperty((Node)taskNode, (String)STATE)));
        task.setStartDate(JcrUtils.getDate((Node)taskNode, (String)START_DATE));
        task.setCompletionDate(JcrUtils.getDate((Node)taskNode, (String)COMPLETION_DATE));
        task.setOwner(JcrUtils.getOptionalProperty((Node)taskNode, (String)OWNING_USER));
        task.setCurrentStepNr(JcrUtils.getIntegerProperty((Node)taskNode, (String)CURRENT_STEP_NR));
        task.setFailureCount(JcrUtils.getIntegerProperty((Node)taskNode, (String)FAILURE_COUNT));
        if (taskNode.hasProperty(CLOUD_OPERATION)) {
            TaskMetadata.putMetadata(task, CLOUD_OPERATION, JcrUtils.getProperty((Node)taskNode, (String)CLOUD_OPERATION));
            TaskMetadata.putMetadata(task, CLOUD_ENVIRONMENT_TEMPLATE_ID, JcrTaskArchive.decodeConfigurationId(JcrUtils.getProperty((Node)taskNode, (String)CLOUD_ENVIRONMENT_TEMPLATE_ID)));
            TaskMetadata.putMetadata(task, CLOUD_ENVIRONMENT_ID, JcrTaskArchive.decodeEnvironmentId(JcrUtils.getProperty((Node)taskNode, (String)CLOUD_ENVIRONMENT_ID)));
        } else if (JcrTaskArchive.isDeploymentTask(task)) {
            TaskMetadata.putMetadata(task, ENVIRONMENT_NAME, JcrUtils.getProperty((Node)taskNode, (String)ENVIRONMENT_NAME));
            if (taskNode.hasProperty(ENVIRONMENT_ID)) {
                TaskMetadata.putMetadata(task, ENVIRONMENT_ID, JcrTaskArchive.decodeEnvironmentId(JcrUtils.getProperty((Node)taskNode, (String)ENVIRONMENT_ID)));
            } else {
                TaskMetadata.putMetadata(task, ENVIRONMENT_ID, JcrTaskArchive.decodeEnvironmentId(JcrUtils.getProperty((Node)taskNode, (String)ENVIRONMENT_NAME)));
            }
            TaskMetadata.putMetadata(task, APPLICATION, JcrUtils.getProperty((Node)taskNode, (String)APPLICATION));
            TaskMetadata.putMetadata(task, VERSION, JcrUtils.getProperty((Node)taskNode, (String)VERSION));
        }
        return task;
    }

    private static List<StepState> getSteps(Node taskNode) throws RepositoryException {
        int nrOfSteps = JcrUtils.getIntegerProperty((Node)taskNode, (String)NR_OF_STEPS);
        ArrayList steps = Lists.newArrayList();
        for (int nr = 1; nr <= nrOfSteps; ++nr) {
            Node stepNode = taskNode.getNode("step" + nr);
            steps.add(JcrTaskArchive.toStep(stepNode));
        }
        return steps;
    }

    private static ArchivedStep toStep(Node stepNode) throws RepositoryException {
        ArchivedStep step = new ArchivedStep();
        step.setDescription(JcrUtils.getProperty((Node)stepNode, (String)DESCRIPTION));
        step.setState(StepExecutionState.valueOf((String)JcrUtils.getProperty((Node)stepNode, (String)STATE)));
        step.setStartDate(JcrUtils.getDate((Node)stepNode, (String)START_DATE));
        step.setCompletionDate(JcrUtils.getDate((Node)stepNode, (String)COMPLETION_DATE));
        step.setLog(JcrUtils.getProperty((Node)stepNode, (String)LOG));
        step.setFailureCount(JcrUtils.getIntegerProperty((Node)stepNode, (String)FAILURE_COUNT));
        return step;
    }

    private static Node getTasksRootNode(Session session) throws RepositoryException {
        return session.getRootNode().getNode("tasks");
    }

    public Collection<ArchivedTask> searchTasks(ArchivedTaskSearchParameters params) {
        return this.searchTasks(params, true);
    }

    public Collection<ArchivedTask> searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters params) {
        return this.searchTasks(params, false);
    }

    private List<ArchivedTask> searchTasks(final ArchivedTaskSearchParameters params, final boolean loadSteps) {
        return (List)this.jcrTemplate.execute((JcrCallback)new JcrCallback<List<ArchivedTask>>(){

            public List<ArchivedTask> doInJcr(Session session) throws RepositoryException {
                QueryResult queryResult = JcrTaskArchive.executeJcrQuery(session, params);
                final ArrayList tasks = Lists.newArrayList();
                JcrTaskArchive.mapQueryResultToTasks(queryResult, loadSteps, new TaskCallback(){

                    @Override
                    public void doWithTask(ArchivedTask t) {
                        tasks.add(t);
                    }
                });
                return tasks;
            }
        });
    }

    public void searchTasks(ArchivedTaskSearchParameters params, TaskCallback callback) {
        this.searchTasks(params, callback, true);
    }

    public void searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters params, TaskCallback callback) {
        this.searchTasks(params, callback, false);
    }

    private Object searchTasks(final ArchivedTaskSearchParameters params, final TaskCallback callback, final boolean loadSteps) {
        return this.jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

            public Object doInJcr(Session session) throws RepositoryException {
                QueryResult queryResult = JcrTaskArchive.executeJcrQuery(session, params);
                JcrTaskArchive.mapQueryResultToTasks(queryResult, loadSteps, callback);
                return null;
            }
        });
    }

    private static QueryResult executeJcrQuery(Session session, ArchivedTaskSearchParameters params) throws RepositoryException {
        QueryManager qm = session.getWorkspace().getQueryManager();
        JcrArchivedTaskSearchQueryBuilder queryBuilder = new JcrArchivedTaskSearchQueryBuilder(qm, session.getValueFactory(), params);
        QueryObjectModel query = queryBuilder.buildQuery();
        return query.execute();
    }

    public List<String> getCloudEnvironmentTemplates() {
        return (List)this.jcrTemplate.execute((JcrCallback)new JcrCallback<List<String>>(){

            public List<String> doInJcr(Session session) throws RepositoryException {
                ArchivedTaskSearchParameters p = new ArchivedTaskSearchParameters().forAllCloudEnvironmentTemplates();
                QueryResult result = JcrTaskArchive.executeJcrQuery(session, p);
                HashSet cloudEnvironmentTemplates = Sets.newHashSet();
                for (Node node : org.apache.jackrabbit.commons.JcrUtils.getNodes((QueryResult)result)) {
                    String templateId = JcrTaskArchive.decodeConfigurationId(JcrUtils.getProperty((Node)node, (String)JcrTaskArchive.CLOUD_ENVIRONMENT_TEMPLATE_ID));
                    cloudEnvironmentTemplates.add(templateId);
                }
                return Lists.newArrayList((Iterable)cloudEnvironmentTemplates);
            }
        });
    }

    public List<String> getAllEnvironments() {
        return (List)this.jcrTemplate.execute((JcrCallback)new JcrCallback<List<String>>(){

            public List<String> doInJcr(Session session) throws RepositoryException {
                ArrayList envs = Lists.newArrayList();
                NodeIterator nodes = session.getNode("/tasks").getNodes();
                while (nodes.hasNext()) {
                    String envId = JcrTaskArchive.decodeEnvironmentId(nodes.nextNode().getName());
                    if (JcrTaskArchive.this.EXCLUDE_SPECIAL_ENV_TASK_NAMES.contains(envId)) continue;
                    envs.add(envId);
                }
                return envs;
            }
        });
    }

    private static void mapQueryResultToTasks(QueryResult result, boolean loadSteps, TaskCallback callback) throws RepositoryException {
        RowIterator iterator = result.getRows();
        while (iterator.hasNext()) {
            try {
                Node taskNode = iterator.nextRow().getNode("task");
                ArchivedTask task = JcrTaskArchive.toTaskWithoutSteps(taskNode);
                if (loadSteps) {
                    task.setSteps(JcrTaskArchive.getSteps(taskNode));
                }
                callback.doWithTask(task);
            }
            catch (RepositoryException rre) {}
        }
    }

    public List<String> getAllTaskIds() {
        return (List)this.jcrTemplate.execute((JcrCallback)new JcrCallback<List<String>>(){

            public List<String> doInJcr(Session session) throws RepositoryException {
                QueryResult queryResult = JcrTaskArchive.executeJcrQuery(session, new ArchivedTaskSearchParameters());
                return JcrTaskArchive.getTaskIds(queryResult);
            }
        });
    }

    private static List<String> getTaskIds(QueryResult queryResult) throws RepositoryException {
        ArrayList taskIds = Lists.newArrayList();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            try {
                taskIds.add(JcrUtils.getProperty((Node)iterator.nextRow().getNode("task"), (String)"$id"));
            }
            catch (RepositoryException repositoryException) {}
        }
        return taskIds;
    }

    public Collection<Map<String, Object>> searchTasksWithoutLoadingSteps(final ArchivedTaskSearchParameters params, final GroupBy groupBy) {
        return (Collection)this.jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

            public Collection<Map<String, Object>> doInJcr(Session session) throws RepositoryException {
                RowIterator iterator = JcrTaskArchive.executeJcrQuery(session, params).getRows();
                while (iterator.hasNext()) {
                    Node taskNode = iterator.nextRow().getNode("task");
                    groupBy.process(JcrTaskArchive.toTaskWithoutSteps(taskNode));
                }
                return groupBy.getResult();
            }
        });
    }

    public static interface TaskCallback {
        public void doWithTask(ArchivedTask var1);
    }
}

