/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.UserService;
import com.xebialabs.deployit.engine.api.security.User;
import com.xebialabs.deployit.engine.spi.event.UserCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.UserDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.UserPasswordChangedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.JcrUser;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class UserResource
extends AbstractSecuredResource
implements UserService {
    @Autowired
    com.xebialabs.deployit.security.UserService userService;
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);

    public User create(String username, User user) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        UserResource.sanityCheckUser(username, user);
        logger.debug("Creating user {}", (Object)username);
        this.userService.create(username, user.getPassword());
        JcrUser u = this.userService.read(username);
        logger.debug("Created user {}", (Object)u.getUsername());
        EventBusHolder.publish((Object)new UserCreatedEvent(username));
        return new User(u.getUsername(), u.isAdmin());
    }

    public User read(String username) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        JcrUser u = this.userService.read(username);
        return new User(u.getUsername(), u.isAdmin());
    }

    public void modifyPassword(String username, User user) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        UserResource.sanityCheckUser(username, user);
        this.userService.modifyPassword(username, user.getPassword());
        EventBusHolder.publish((Object)new UserPasswordChangedEvent(username));
    }

    public void delete(String username) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.userService.delete(username);
        EventBusHolder.publish((Object)new UserDeletedEvent(username));
    }

    private static void sanityCheckUser(String username, User user) {
        if (user.getUsername() != null && !user.getUsername().equals(username)) {
            throw new IllegalArgumentException("Username in URL is " + username + " but username in POST data is " + user.getUsername());
        }
    }
}

