/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DeploymentWriter;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreview;
import com.xebialabs.deployit.engine.spi.event.TaskCreatedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.tasker.PreviewStepAdapter;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.ChangeSetBuilder;
import com.xebialabs.deployit.service.deployment.DeployedService;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.deployment.RollbackService;
import com.xebialabs.deployit.service.validation.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.PathParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeploymentResource
extends AbstractSecuredResource
implements com.xebialabs.deployit.engine.api.DeploymentService {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private DeployedService deployedService;
    @Autowired
    private RollbackService rollbackService;
    @Autowired
    private TaskExecutionEngine engine;
    @Autowired
    private Validator validator;
    @Autowired
    private WorkDirFactory workDirFactory;
    private Cache<String, PreviewWithWorkdir> previewCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new PreviewCleaner()).build();
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);

    public boolean isDeployed(String applicationId, String environmentId) {
        logger.trace("isDeployed {}, {}", (Object)applicationId, (Object)environmentId);
        Checks.checkNotNull((Object)applicationId, (String)"application");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        ConfigurationItem application = this.repositoryService.read(applicationId);
        ConfigurationItem environment = this.repositoryService.read(environmentId);
        Checks.checkArgument((boolean)(application instanceof Application), (String)"%s is not an udm.Application", (Object[])new Object[]{applicationId});
        Checks.checkArgument((boolean)(environment instanceof Environment), (String)"%s is not an udm.Environment", (Object[])new Object[]{environmentId});
        return this.repositoryService.exists(IdGenerator.generateId((String)((Environment)environment).getId(), (String)((Application)application).getId()));
    }

    public Deployment prepareInitial(String versionId, String environmentId) {
        logger.trace("prepareInitial {}, {}", (Object)versionId, (Object)environmentId);
        this.checkPermission(DeployitPermissions.DEPLOY_INITIAL, environmentId);
        Checks.checkNotNull((Object)versionId, (String)"version");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        ConfigurationItem version = this.repositoryService.read(versionId);
        ConfigurationItem environment = this.repositoryService.read(environmentId);
        Checks.checkArgument((boolean)(version instanceof Version), (String)"%s is not a Version", (Object[])new Object[]{versionId});
        Checks.checkArgument((boolean)(environment instanceof Environment), (String)"%s is not an Environment", (Object[])new Object[]{environmentId});
        Deployment deployment = DeploymentWriter.createDeployment(this.deployedService.generateDeployedApplication((Version)version, (Environment)environment), Deployment.DeploymentType.INITIAL);
        return deployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deployment prepareUpdate(String newVersionId, String deployedApplicationId) {
        logger.trace("prepareUpgrade {}, {}", (Object)newVersionId, (Object)deployedApplicationId);
        Checks.checkNotNull((Object)newVersionId, (String)"version");
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        WorkDir existingWorkDir = this.workDirFactory.newWorkDir();
        WorkDir newWorkDir = this.workDirFactory.newWorkDir();
        try {
            ConfigurationItem deployedApplication = this.repositoryService.read(deployedApplicationId, existingWorkDir);
            Checks.checkArgument((boolean)(deployedApplication instanceof DeployedApplication), (String)"%s is not a DeployedApplication", (Object[])new Object[]{deployedApplicationId});
            Environment env = ((DeployedApplication)deployedApplication).getEnvironment();
            this.checkPermission(DeployitPermissions.DEPLOY_UPGRADE, env.getId());
            ConfigurationItem newVersion = this.repositoryService.read(newVersionId, newWorkDir);
            Checks.checkArgument((boolean)(newVersion instanceof Version), (String)"%s is not a Version", (Object[])new Object[]{newVersionId});
            ListMultimap upgradedDeployeds = this.deployedService.generateUpgradedDeployeds((Version)newVersion, (DeployedApplication)deployedApplication);
            DeployedApplication deplApp = this.deployedService.generateUpdateDeployedApplication((DeployedApplication)deployedApplication, (Version)newVersion);
            logger.debug("Generated upgrade deployed application [{}] with version [{}] and env [{}]", new Object[]{deplApp, deplApp.getVersion(), deplApp.getEnvironment()});
            logger.debug("Upgrade deployed application contains [{}] deployeds", (Object)deplApp.getDeployeds());
            Deployment deployment = DeploymentWriter.createDeployment(deplApp, Deployment.DeploymentType.UPDATE);
            deployment.setDeployeds(DeploymentWriter.convertDeployeds((ListMultimap<Boolean, ConfigurationItem>)upgradedDeployeds));
            Deployment deployment2 = deployment;
            return deployment2;
        }
        finally {
            existingWorkDir.delete();
            newWorkDir.delete();
        }
    }

    public Deployment prepareUndeploy(String deployedApplicationId) {
        logger.trace("prepareUndeployApplication {}", (Object)deployedApplicationId);
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        ConfigurationItem application = this.repositoryService.read(deployedApplicationId);
        Checks.checkArgument((boolean)(application instanceof DeployedApplication), (String)"%s is not a DeployedApplication", (Object[])new Object[]{deployedApplicationId});
        DeployedApplication deployedApplication = (DeployedApplication)application;
        this.checkPermission(DeployitPermissions.UNDEPLOY, deployedApplication.getEnvironment().getId());
        Deployment deployment = DeploymentWriter.createDeployment(deployedApplication, Deployment.DeploymentType.UNDEPLOYMENT);
        return deployment;
    }

    public Deployment prepareAutoDeployeds(Deployment deployment) {
        logger.trace("updateDeployeds {}", (Object)deployment);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        ListMultimap additionalDeployeds = this.deployedService.createDeployedsForNonExistingCombinations(version, environment, DeploymentResource.getDeployeds(deployment));
        deployment.getDeployeds().clear();
        deployment.addAll(DeploymentWriter.convertDeployeds((ListMultimap<Boolean, ConfigurationItem>)additionalDeployeds));
        return deployment;
    }

    private DeployedApplication preGenerateCheck(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.invalidatePreview(deployment);
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        this.checkPermission(DeployitPermissions.DEPLOY_INITIAL, deployedApplication.getEnvironment().getId());
        return deployedApplication;
    }

    public Deployment generateAllDeployeds(Deployment deployment) {
        logger.trace("generateAllDeployeds {}", (Object)deployment);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        ListMultimap initialDeployeds = this.deployedService.generateAllDeployeds(version, environment);
        deployment.addAll(DeploymentWriter.convertDeployeds((ListMultimap<Boolean, ConfigurationItem>)initialDeployeds));
        return deployment;
    }

    private void invalidatePreview(Deployment deployment) {
        if (deployment.getId() != null) {
            this.previewCache.invalidate((Object)deployment.getId());
        }
    }

    public Deployment generateSelectedDeployeds(List<String> deployableIds, Deployment deployment) {
        logger.trace("generateSelectedDeployeds {}, {}", deployableIds, (Object)deployment);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        logger.debug("Generating deployeds from package [{}]", (Object)version);
        Environment environment = deployedApplication.getEnvironment();
        Checks.checkArgument((deployableIds.size() > 0 ? 1 : 0) != 0, (String)"Should select at least one deployable to generate a deployed", (Object[])new Object[0]);
        ImmutableMap deployables = Maps.uniqueIndex((Iterable)version.getDeployables(), (Function)new Function<Deployable, String>(){

            public String apply(Deployable input) {
                return input.getId();
            }
        });
        ArrayList deployableCIs = Lists.newArrayList();
        for (String id : deployableIds) {
            Checks.checkArgument((boolean)deployables.containsKey(id), (String)"All sources should be from same package", (Object[])new Object[0]);
            deployableCIs.add(deployables.get(id));
        }
        ListMultimap selectedDeployeds = this.deployedService.generateSelectedDeployeds((List)deployableCIs, version, environment);
        deployment.addAll(DeploymentWriter.convertDeployeds((ListMultimap<Boolean, ConfigurationItem>)selectedDeployeds));
        return deployment;
    }

    public Deployment generateSingleDeployed(final String deployableId, final String containerId, Type deployedType, Deployment deployment) {
        logger.debug("Creating explicit deployed for [{}] and [{}]", (Object)deployableId, (Object)containerId);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        Checks.checkNotNull((Object)deployableId, (String)"deployable");
        Checks.checkNotNull((Object)containerId, (String)"container");
        ConfigurationItem deployable = (ConfigurationItem)Iterables.find((Iterable)version.getDeployables(), (Predicate)new Predicate<Deployable>(){

            public boolean apply(Deployable input) {
                return input.getId().equals(deployableId);
            }
        });
        Checks.checkArgument((boolean)(deployable instanceof Deployable), (String)"%s should be a Deployable.", (Object[])new Object[]{deployableId});
        ConfigurationItem container = (ConfigurationItem)Iterables.find((Iterable)environment.getMembers(), (Predicate)new Predicate<Container>(){

            public boolean apply(Container input) {
                return input.getId().equals(containerId);
            }
        });
        Checks.checkArgument((boolean)(container instanceof Container), (String)"%s should be a Container.", (Object[])new Object[]{containerId});
        ListMultimap deployeds = this.deployedService.createSelectedDeployed((Deployable)deployable, (Container)container, deployedType, version, environment);
        deployment.addAll(DeploymentWriter.convertDeployeds((ListMultimap<Boolean, ConfigurationItem>)deployeds));
        return deployment;
    }

    public Deployment validate(Deployment deployment) {
        this.invalidatePreview(deployment);
        if (!this.validateDeploymentWithValidator(deployment)) {
            throw new InvalidDeploymentException(deployment);
        }
        return deployment;
    }

    @Workdir
    public TaskPreview taskPreview(final Deployment deployment) {
        return (TaskPreview)WorkDirTemplate.cleanOnException((WorkDirTemplate.Callback)new WorkDirTemplate.Callback<TaskPreview>(){

            public TaskPreview doWithWorkdir(WorkDir workDir) {
                DeploymentResource.this.checkDeploymentInput(deployment);
                try {
                    DeploymentResource.this.invalidatePreview(deployment);
                    return ((DeploymentResource)DeploymentResource.this).getTaskPreview((Deployment)deployment, (WorkDir)workDir).preview;
                }
                catch (Exception e) {
                    throw new DeployitException((Throwable)e, "Error getting task preview for deployment [%s]", new Object[]{deployment.getId()});
                }
            }
        });
    }

    @Workdir
    public StepState stepPreview(final Deployment deployment, final @PathParam(value="stepNr") int stepNr) {
        return (StepState)WorkDirTemplate.cleanOnException((WorkDirTemplate.Callback)new WorkDirTemplate.Callback<StepState>(){

            public StepState doWithWorkdir(WorkDir workDir) {
                PreviewWithWorkdir taskPreview;
                DeploymentResource.this.checkDeploymentInput(deployment);
                try {
                    taskPreview = DeploymentResource.this.getTaskPreview(deployment, workDir);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DeployitException((Throwable)e, "Error getting task preview for deployment [%s]", new Object[]{deployment.getId()});
                }
                if (!taskPreview.workDir.getPath().equals(workDir.getPath())) {
                    workDir.delete();
                }
                List steps = taskPreview.preview.getSteps();
                Checks.checkArgument((stepNr > 0 && stepNr <= steps.size() ? 1 : 0) != 0, (String)"Not a valid step number [%s]", (Object[])new Object[]{stepNr});
                StepState stepState = (StepState)steps.get(stepNr - 1);
                if (DeploymentResource.this.hasPermission(DeployitPermissions.TASK_PREVIEWSTEP)) {
                    return new PreviewStepAdapter((TaskStep)stepState);
                }
                return stepState;
            }
        });
    }

    private PreviewWithWorkdir getTaskPreview(final Deployment deployment, final WorkDir workDir) throws ExecutionException {
        String id = deployment.getId();
        Checks.checkArgument((id != null ? 1 : 0) != 0, (String)"Old-style client detected, deployment does not have an 'id' set. Please upgrade your client.", (Object[])new Object[0]);
        return (PreviewWithWorkdir)this.previewCache.get((Object)id, (Callable)new Callable<PreviewWithWorkdir>(){

            @Override
            public PreviewWithWorkdir call() throws Exception {
                logger.info("Generating task preview for deployment [{}]", (Object)deployment.getId());
                ConfigurationItem configurationItem = DeploymentResource.this.validateDeployedApplication(deployment.getDeployedApplication());
                if (configurationItem instanceof ValidatedConfigurationItem) {
                    throw new InvalidDeploymentException("The DeployedApplication contained validation errors, not generating a steps view.");
                }
                DeploymentResource.this.filterDeployedsWithValidationErrors(deployment);
                TaskSpecification taskSpecification = DeploymentResource.this.createDeploymentTask(deployment, true);
                logger.info("Done generating task preview for deployment [{}]", (Object)deployment.getId());
                TaskPreview preview = new TaskPreview(deployment.getId(), (List)Lists.newArrayList((Iterable)taskSpecification.getSteps()));
                return new PreviewWithWorkdir(preview, workDir);
            }
        });
    }

    private void filterDeployedsWithValidationErrors(Deployment deployment) {
        for (ConfigurationItem configurationItem : Lists.newArrayList((Iterable)deployment.getDeployeds())) {
            if (this.validator.validate(configurationItem, new ConfigurationItem[0]).size() <= 0) continue;
            logger.debug("ConfigurationItem [{} ({})] contained validation errors, not taking it into account for steps view.", (Object)configurationItem.getId(), (Object)configurationItem.getType());
            deployment.getDeployeds().remove(configurationItem);
        }
    }

    @Workdir
    public String createTask(final Deployment deployment) {
        return (String)WorkDirTemplate.cleanOnException((WorkDirTemplate.Callback)new WorkDirTemplate.Callback<String>(){

            public String doWithWorkdir(WorkDir workDir) {
                DeploymentResource.this.checkDeploymentInput(deployment);
                if (!DeploymentResource.this.validateDeploymentWithValidator(deployment)) {
                    throw new InvalidDeploymentException("The deployment has validation errors.");
                }
                DeploymentResource.this.invalidatePreview(deployment);
                logger.trace("Creating task for {}", (Object)deployment);
                TaskSpecification deploymentTask = DeploymentResource.this.createDeploymentTask(deployment, false);
                String taskId = DeploymentResource.this.engine.register(deploymentTask);
                logger.debug("Registered {} task {} for Deployed Application {}", new Object[]{deployment.getDeploymentType(), taskId, deployment.getDeployedApplication().getId()});
                EventBusHolder.publish((Object)new TaskCreatedEvent(taskId, deployment.getDeploymentType().toString(), deployment.getDeployedApplication().getId()));
                return taskId;
            }
        });
    }

    private void checkDeploymentInput(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(deployment);
    }

    public String rollback(@PathParam(value="taskid") String taskid) {
        Task retrieve = this.engine.retrieve(taskid);
        TaskSpecification rollback = this.rollbackService.rollback(retrieve);
        return this.engine.register(rollback);
    }

    private void checkPermission(Deployment deployment) {
        String environment = ((DeployedApplication)deployment.getDeployedApplication()).getEnvironment().getId();
        switch (deployment.getDeploymentType()) {
            case INITIAL: {
                this.checkPermission(DeployitPermissions.DEPLOY_INITIAL, environment);
                break;
            }
            case UPDATE: {
                this.checkPermission(DeployitPermissions.DEPLOY_UPGRADE, environment);
                break;
            }
            case UNDEPLOYMENT: {
                this.checkPermission(DeployitPermissions.UNDEPLOY, environment);
            }
        }
    }

    private TaskSpecification createDeploymentTask(Deployment deployment, boolean previewMode) {
        switch (deployment.getDeploymentType()) {
            case INITIAL: {
                return this.createInitialDeploymentTask(deployment, previewMode);
            }
            case UPDATE: {
                return this.createUpdateTask(deployment, previewMode);
            }
            case UNDEPLOYMENT: {
                return this.createUndeploymentTask(deployment, previewMode);
            }
        }
        throw new IllegalArgumentException("Unknown deployment type: " + deployment.getDeploymentType());
    }

    private TaskSpecification createInitialDeploymentTask(Deployment deployment, boolean previewMode) {
        DeployedApplication deployedApp = (DeployedApplication)deployment.getDeployedApplication();
        deployedApp.addDeployeds(DeploymentResource.getDeployeds(deployment));
        DeltaSpecification deltaSpecification = this.deploymentService.prepareInitialDeployment(deployedApp);
        if (!previewMode) {
            this.repositoryService.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((DeltaSpecification)deltaSpecification));
        }
        return this.deploymentService.getTaskSpecification(deltaSpecification, WorkdirHolder.get(), new WorkDir[0]);
    }

    private TaskSpecification createUpdateTask(Deployment deployment, boolean previewMode) {
        DeployedApplication deployedApp = (DeployedApplication)deployment.getDeployedApplication();
        deployedApp.addDeployeds(DeploymentResource.getDeployeds(deployment));
        WorkDir workDirForExistingDeployment = this.workDirFactory.newWorkDir();
        logger.trace("Got workdir [{}] for reading existing deployment", (Object)workDirForExistingDeployment);
        try {
            DeployedApplication existingDeployedApplication = (DeployedApplication)this.repositoryService.read(deployment.getDeployedApplication().getId(), workDirForExistingDeployment);
            DeltaSpecification deltaSpecification = this.deploymentService.prepareUpgradeDeployment(deployedApp, existingDeployedApplication);
            if (!previewMode) {
                this.repositoryService.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((DeltaSpecification)deltaSpecification));
            }
            return this.deploymentService.getTaskSpecification(deltaSpecification, workDirForExistingDeployment, new WorkDir[]{WorkdirHolder.get()});
        }
        catch (RuntimeException e) {
            workDirForExistingDeployment.delete();
            WorkdirHolder.get().delete();
            throw e;
        }
    }

    private TaskSpecification createUndeploymentTask(Deployment deployment, boolean previewMode) {
        DeployedApplication deployedApplication = (DeployedApplication)this.repositoryService.read(deployment.getDeployedApplication().getId());
        this.checkPermission(DeployitPermissions.UNDEPLOY, deployedApplication.getEnvironment().getId());
        DeltaSpecification deltaSpecification = this.deploymentService.prepareUndeployment(deployedApplication);
        if (!previewMode) {
            this.repositoryService.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((DeltaSpecification)deltaSpecification));
        }
        return this.deploymentService.getTaskSpecification(deltaSpecification, WorkdirHolder.get(), new WorkDir[0]);
    }

    private static HashSet<Deployed> getDeployeds(Deployment deployment) {
        List deployedEntities = deployment.getDeployeds();
        FluentIterable from = FluentIterable.from((Iterable)deployedEntities);
        Checks.checkArgument((boolean)from.allMatch(Predicates.or((Predicate)Predicates.instanceOf(Deployed.class), (Predicate)Predicates.instanceOf(EmbeddedDeployed.class))), (String)"The Deployment can only contain Deployed or EmbeddedDeployed configuration items", (Object[])new Object[0]);
        return Sets.newHashSet((Iterable)from.filter(Deployed.class));
    }

    private boolean validateDeploymentWithValidator(Deployment deployment) {
        deployment.setDeployedApplication(this.validateDeployedApplication(deployment.getDeployedApplication()));
        boolean deployedApplicationValid = !(deployment.getDeployedApplication() instanceof ValidatedConfigurationItem);
        boolean deployedsValid = true;
        try {
            this.validator.validateCis(deployment.getDeployeds());
        }
        catch (Validator.ValidationsFailedException ignored) {
            deployedsValid = false;
        }
        HashSet ids = Sets.newHashSet();
        ArrayList validated = Lists.newArrayList();
        for (ConfigurationItem configurationItem : deployment.getDeployeds()) {
            if (!ids.add(configurationItem.getId())) {
                ValidatedConfigurationItem vci;
                if (configurationItem instanceof ValidatedConfigurationItem) {
                    vci = (ValidatedConfigurationItem)configurationItem;
                    configurationItem = vci.getWrapped();
                } else {
                    vci = new ValidatedConfigurationItem(configurationItem);
                }
                vci.getValidations().add(new ValidationMessage(configurationItem.getId(), "name", String.format("The deployed [%s] must have a unique name within the container [%s]", configurationItem, ((EmbeddedDeployedContainer)configurationItem).getContainer())));
                validated.add(vci);
                deployedsValid = false;
                continue;
            }
            validated.add(configurationItem);
        }
        deployment.setDeployeds((List)validated);
        return deployedsValid && deployedApplicationValid;
    }

    private ConfigurationItem validateDeployedApplication(ConfigurationItem deployedApplicationEntity) {
        List messages = this.validator.validate(deployedApplicationEntity, Collections.EMPTY_LIST);
        Iterable filteredMessages = Iterables.filter((Iterable)messages, (Predicate)new Predicate<ValidationMessage>(){

            public boolean apply(ValidationMessage input) {
                return !"deployeds".equals(input.getPropertyName());
            }
        });
        if (Iterables.size((Iterable)filteredMessages) > 0) {
            ValidatedConfigurationItem validatedConfigurationItem = new ValidatedConfigurationItem(deployedApplicationEntity);
            validatedConfigurationItem.setValidations((List)Lists.newArrayList((Iterable)filteredMessages));
            return validatedConfigurationItem;
        }
        return deployedApplicationEntity;
    }

    @HttpResponseCodeResult(statusCode=400)
    private class InvalidDeploymentException
    extends DeployitException {
        public InvalidDeploymentException(Deployment deployment) {
            super((Object)deployment);
        }

        public InvalidDeploymentException(String message) {
            super(message);
        }
    }

    private static class PreviewCleaner
    implements RemovalListener<String, PreviewWithWorkdir> {
        private PreviewCleaner() {
        }

        public void onRemoval(RemovalNotification<String, PreviewWithWorkdir> notification) {
            if (notification.getValue() != null) {
                logger.info("Cleaning up Preview [%s] with workDir [%s]", notification.getKey(), (Object)((PreviewWithWorkdir)notification.getValue()).workDir);
                ((PreviewWithWorkdir)notification.getValue()).cleanUp();
            }
        }
    }

    private static class PreviewWithWorkdir {
        TaskPreview preview;
        WorkDir workDir;

        private PreviewWithWorkdir(TaskPreview preview, WorkDir workDir) {
            this.preview = preview;
            this.workDir = workDir;
        }

        void cleanUp() {
            this.workDir.delete();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.workDir.delete();
        }
    }
}

