/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.EnumSet;
import org.joda.time.ReadableInstant;

public class ProvisioningReport
extends TaskArchiveReport {
    public ProvisioningReport(JcrTaskArchive taskArchive) {
        super(taskArchive);
        this.getSearchParameters().thatAreOfType(EnumSet.of(TaskType.CONTROL));
    }

    public Report report() {
        final Report report = new Report();
        this.taskArchive.searchTasksWithoutLoadingSteps(this.getSearchParameters(), new JcrTaskArchive.TaskCallback(){

            public void doWithTask(ArchivedTask task) {
                Report.ReportLine line = report.addLine();
                line.addValue("taskId", (Object)task.getId());
                line.addValue("user", (Object)task.getOwner());
                line.addValue("status", (Object)task.getState2().name());
                line.addValue("startDate", (Object)ReportUtils.FORMATTER.print((ReadableInstant)task.getStartDate()));
                line.addValue("completionDate", (Object)ReportUtils.FORMATTER.print((ReadableInstant)task.getCompletionDate()));
                line.addValue("type", (Object)ProvisioningReport.getTaskType(task));
                line.addValue("cloudOperation", (Object)TaskMetadata.getMetadata((TaskWithSteps)task, (String)"cloudOperation"));
                line.addValue("cloudEnvironmentId", (Object)TaskMetadata.getMetadata((TaskWithSteps)task, (String)"cloudEnvironmentId"));
                line.addValue("cloudEnvironmentTemplateId", (Object)TaskMetadata.getMetadata((TaskWithSteps)task, (String)"cloudEnvironmentTemplateId"));
            }
        });
        return report;
    }

    private static String getTaskType(ArchivedTask task) {
        String taskType = "Unknown";
        TaskType type = TaskType.valueOf((String)TaskMetadata.getMetadata((TaskWithSteps)task, (String)"taskType"));
        switch (type) {
            case CONTROL: {
                taskType = "Control";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected taskType in ProvisioningReport '%s'", type.name()));
            }
        }
        return taskType;
    }
}

