/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.Tuple;
import java.util.List;

public class ChangeSet {
    private List<ConfigurationItem> createCis = Lists.newArrayList();
    private List<ConfigurationItem> updateCis = Lists.newArrayList();
    private List<String> deleteCiIds = Lists.newArrayList();
    private List<Tuple<String, String>> moveCis = Lists.newArrayList();
    private List<Tuple<String, String>> copyCis = Lists.newArrayList();
    private List<Tuple<String, String>> renameCis = Lists.newArrayList();
    private List<ConfigurationItem> createOrUpdateCis = Lists.newArrayList();
    private List<ConfigurationItem> createOrUpdateActualUpdatedCis = Lists.newArrayList();
    private List<ConfigurationItem> createOrUpdateActualCreatedCis = Lists.newArrayList();
    private boolean checkPointRequested = true;

    public void create(ConfigurationItem ci) {
        this.createCis.add(ci);
    }

    public void update(ConfigurationItem ci) {
        this.updateCis.add(ci);
    }

    public void delete(ConfigurationItem ci) {
        this.deleteCiIds.add(ci.getId());
    }

    public void move(String ci, String newId) {
        this.moveCis.add(Tuple.of(ci, newId));
    }

    public void copy(String ci, String newId) {
        this.copyCis.add(Tuple.of(ci, newId));
    }

    public void rename(ConfigurationItem ci, String newName) {
        this.renameCis.add(Tuple.of(ci.getId(), newName));
    }

    public List<ConfigurationItem> getCreateCis() {
        return this.createCis;
    }

    public void setCreateCis(List<ConfigurationItem> createCis) {
        this.createCis = createCis;
    }

    public List<ConfigurationItem> getUpdateCis() {
        return this.updateCis;
    }

    public void setUpdateCis(List<ConfigurationItem> updateCis) {
        this.updateCis = updateCis;
    }

    public List<String> getDeleteCiIds() {
        return this.deleteCiIds;
    }

    public void setDeleteCiIds(List<String> deleteCiIds) {
        this.deleteCiIds = deleteCiIds;
    }

    public <T extends ConfigurationItem> void addMoveCi(String id, String newId) {
        this.moveCis.add(Tuple.of(id, newId));
    }

    public <T extends ConfigurationItem> void addCopyCi(String id, String newId) {
        this.copyCis.add(Tuple.of(id, newId));
    }

    public List<Tuple<String, String>> getMoveCis() {
        return this.moveCis;
    }

    public <T extends ConfigurationItem> void addRenameCi(String entity, String newName) {
        this.renameCis.add(Tuple.of(entity, newName));
    }

    public List<Tuple<String, String>> getRenameCis() {
        return this.renameCis;
    }

    public <T extends ConfigurationItem> void createOrUpdate(List<T> entities) {
        this.createOrUpdateCis.addAll(entities);
    }

    public <T extends ConfigurationItem> void createOrUpdate(T entity) {
        this.createOrUpdateCis.add(entity);
    }

    public List<ConfigurationItem> getCreateOrUpdateCis() {
        return this.createOrUpdateCis;
    }

    public List<Tuple<String, String>> getCopyCis() {
        return this.copyCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualUpdatedCis() {
        return this.createOrUpdateActualUpdatedCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualCreatedCis() {
        return this.createOrUpdateActualCreatedCis;
    }

    public boolean isCheckPointRequested() {
        return this.checkPointRequested;
    }

    public void setCheckPointRequested(boolean checkPointRequested) {
        this.checkPointRequested = checkPointRequested;
    }
}

