/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.rules;

import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.deployment.rules.OldRule;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.rules.DeploymentRule;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeploymentRule(value="deployed")
public class DeployedInvokerRule
extends OldRule<Delta> {
    private Type deployedType;
    private Operation operation;
    private Method method;
    private static final Logger logger = LoggerFactory.getLogger(DeployedInvokerRule.class);

    public DeployedInvokerRule(Type deployedType, Method typeContributor, Operation operation) {
        super(DeployedInvokerRule.buildName(deployedType, typeContributor, operation), true);
        this.deployedType = deployedType;
        this.method = typeContributor;
        this.operation = operation;
    }

    private static String buildName(Type deployedType, Method typeContributor, Operation operation) {
        return String.format("%s.%s_%s", deployedType, typeContributor.getName(), operation);
    }

    @Override
    public boolean canFire(Delta delta, DeploymentPlanningContext context) {
        return delta.getOperation() == this.operation && this.getDeployed(delta).getType().instanceOf(this.deployedType);
    }

    @Override
    public void fire(Delta delta, DeploymentPlanningContext context) {
        Deployed deployed = this.getDeployed(delta);
        try {
            if (this.method.getParameterTypes().length == 2) {
                this.method.invoke((Object)deployed, context, delta);
            } else {
                this.method.invoke((Object)deployed, context);
            }
        }
        catch (IllegalAccessException e) {
            throw new DeploymentPlanner.PlannerException(e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e, (String)"");
        }
    }

    private Deployed getDeployed(Delta delta) {
        if (delta.getOperation() == Operation.DESTROY) {
            return delta.getPrevious();
        }
        return delta.getDeployed();
    }
}

