/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.setup;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.util.DeployitKeyStore;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class Setup {
    private static final String EXITSETUP_KEYWORD = "exitsetup";
    private final String serverName;
    private final ServerConfigFile serverConfigFile;
    private final ServerLaunchOptions launchOptions;
    private ServerConfiguration configuration;
    private boolean askImportablePackagesPath = true;
    private boolean askServerUrl = false;
    private boolean storeRepositoryIdWhenInitializingJcr = false;
    private boolean generateKeyStore;
    private boolean initializeJcrRepository;
    private boolean generatePasswordEncryptionKey;
    private String passwordEncryptionKeyPassword;
    private String repositoryId;

    public Setup(String serverName, ServerConfigFile serverConfigFile, ServerLaunchOptions deployitOptions) {
        this(serverName, serverConfigFile, deployitOptions, new ServerConfiguration());
    }

    public Setup(String serverName, ServerConfigFile serverConfigFile, ServerLaunchOptions deployitOptions, ServerConfiguration defaultConfiguration) {
        this.serverName = serverName;
        this.serverConfigFile = serverConfigFile;
        this.launchOptions = deployitOptions;
        this.configuration = defaultConfiguration;
    }

    public boolean isAskImportablePackagesPath() {
        return this.askImportablePackagesPath;
    }

    public void setAskImportablePackagesPath(boolean askImportablePackagesPath) {
        this.askImportablePackagesPath = askImportablePackagesPath;
    }

    public void setAskServerUrl(boolean askServerUrl) {
        this.askServerUrl = askServerUrl;
    }

    public void run() {
        if (this.launchOptions.isReinitialize()) {
            this.reinitialize();
        } else {
            this.runComplete();
        }
    }

    private void reinitialize() {
        if (!this.launchOptions.isForce()) {
            System.out.println("The -reinitialize will only work with a default repository setup; Not when you've configured " + this.serverName + "  to integrate with a database.");
            System.out.println("Are you sure you want to continue (yes or no)?");
            if (!Setup.getBooleanResponse(false)) {
                return;
            }
        }
        String repositoryKeystorePassword = this.launchOptions.getRepositoryKeystorePassword();
        SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeystorePassword);
        PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        this.useDefaultValues(this.launchOptions.getDefaultsFile());
        this.serverConfigFile.writeConfiguration(this.configuration);
        this.configuration = this.serverConfigFile.loadConfig();
        this.initializeJcrRepository();
        Setup.deleteTaskRecoveryFile();
    }

    private void runComplete() {
        SecretKey passwordEncryptionKey;
        System.out.println("\nWelcome to the " + this.serverName + " setup.");
        System.out.println("You can always exit by typing 'exitsetup'.");
        System.out.println("To re-run this setup and make changes to the " + this.serverName + " configuration you can run server.cmd -setup on Windows or server.sh -setup on Unix.");
        boolean editingExistingConfiguration = false;
        if (this.serverConfigFile.exists() && this.askDoYouWantToEditTheExistingConfiguration()) {
            passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)this.launchOptions.getRepositoryKeystorePassword());
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
            this.serverConfigFile.readIntoConfiguration(this.configuration);
            editingExistingConfiguration = true;
        }
        if (Setup.askToUseSimpleSetup()) {
            if (!editingExistingConfiguration) {
                this.askAdminPassword();
            } else {
                this.upgradeConfigurationWithDefaultValues();
            }
            this.askToInitializeJcr();
        } else {
            if (!editingExistingConfiguration) {
                this.askAdminPassword();
            }
            if (this.askToEnableSsl()) {
                if (this.askToGenerateKeys()) {
                    this.setDefaultKeyStoreSettings();
                } else {
                    this.askKeyStoreSettings();
                }
            }
            this.askHttpBindAddressForJetty();
            this.askHttpPortForJetty();
            this.askWebContextRoot();
            this.askServerUrl();
            this.askMinumAmountOfThreads();
            this.askMaximumAmountOfThreads();
            this.askJcrRepositoryPath();
            this.askToInitializeJcr();
            this.askImportablePackagesPath();
        }
        if (this.reviewAndConfirm()) {
            passwordEncryptionKey = null;
            if (this.generatePasswordEncryptionKey) {
                DeployitKeyStore.generateRandomKeyStore((File)new File("conf"), (String)this.passwordEncryptionKeyPassword);
                passwordEncryptionKey = DeployitKeyStore.getPasswordEncryptionKey();
            } else {
                passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)this.launchOptions.getRepositoryKeystorePassword());
            }
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
            System.out.println("Saving to " + this.serverConfigFile);
            this.serverConfigFile.writeConfiguration(this.configuration);
            System.out.println("Configuration saved.");
            if (this.generateKeyStore) {
                this.generateKeyStore();
            }
            this.configuration = this.serverConfigFile.loadConfig();
            if (this.initializeJcrRepository) {
                this.initializeJcrRepository();
            }
            System.out.println("You can now start your " + this.serverName + " by executing the command server.cmd on Windows or server.sh on Unix.");
            System.out.println("Note: If your " + this.serverName + " is running please restart it.");
            System.out.println("Finished setup.");
        } else {
            System.out.println("Aborting setup.");
        }
    }

    private void useDefaultValues(String defaultsFile) {
        block4: {
            this.configuration.setDefaults();
            if (defaultsFile == null) break block4;
            File file = new File(defaultsFile);
            Preconditions.checkState((boolean)file.exists(), (String)"The given file [%s] with defaults does not exist.", (Object[])new Object[]{defaultsFile});
            Properties properties = new Properties();
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(file);
                properties.load(inStream);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Cannot load [" + file + "] to read defaults from.");
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(inStream);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)inStream);
            this.configuration.load(properties);
        }
    }

    private void askAdminPassword() {
        Setup.printEmptyLine();
        System.out.println("Please enter the admin password you wish to use for " + this.serverName);
        String password = Setup.getConfirmedPassword();
        if (Strings.isNullOrEmpty((String)password)) {
            System.out.println("Using default admin password.");
            this.configuration.setAdminPassword("admin");
        } else {
            this.configuration.setAdminPassword(password);
        }
    }

    private void askWebContextRoot() {
        Setup.printEmptyLine();
        System.out.println("Enter the web context root where " + this.serverName + " will run");
        String contextRoot = Setup.getStringResponse("/");
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        this.configuration.setWebContextRoot(contextRoot);
    }

    private void askServerUrl() {
        if (!this.askServerUrl) {
            return;
        }
        Setup.printEmptyLine();
        System.out.println("Enter the public URL to access " + this.serverName);
        String derivedUrl = this.configuration.getDerivedServerUrl();
        String serverUrl = Setup.getStringResponse(derivedUrl);
        if (!derivedUrl.equals(serverUrl)) {
            this.configuration.setServerUrl(serverUrl);
        }
    }

    private void upgradeConfigurationWithDefaultValues() {
        if (this.configuration.getMinThreads() == 0) {
            this.configuration.setMinThreads(3);
        }
        if (this.configuration.getMaxThreads() == 0) {
            this.configuration.setMaxThreads(24);
        }
        if (this.configuration.getImportablePackagesPath() == null) {
            this.configuration.setImportablePackagesPath("importablePackages");
        }
    }

    private void askMinumAmountOfThreads() {
        Setup.printEmptyLine();
        System.out.println("Enter the minimum number of threads the HTTP server should use (recommended: 3 per client, so 3 for single user usage)");
        int minThreads = 3;
        int suppliedMinThreads = this.configuration.getMinThreads() == 0 ? minThreads : this.configuration.getMinThreads();
        this.configuration.setMinThreads(Setup.getValidIntegerResponse(suppliedMinThreads));
    }

    private void askMaximumAmountOfThreads() {
        Setup.printEmptyLine();
        System.out.println("Enter the maximum number of threads the HTTP server should use (recommended :3 per client, so 24 for 8 concurrent users)");
        int maxThreads = 24;
        int suppliedMaxThreads = this.configuration.getMaxThreads() == 0 ? maxThreads : this.configuration.getMaxThreads();
        this.configuration.setMaxThreads(Setup.getValidIntegerResponse(suppliedMaxThreads));
    }

    private static boolean askToUseSimpleSetup() {
        Setup.printEmptyLine();
        System.out.println("Do you want to use the simple setup?");
        System.out.println("Default values are used for all properties. To make changes to the default properties, please answer no.");
        System.out.println("Options are yes or no.");
        return Setup.getBooleanResponse(true);
    }

    private boolean askToEnableSsl() {
        Setup.printEmptyLine();
        System.out.println("Would you like to enable SSL?");
        System.out.println("Options are yes or no.");
        boolean suppliedSsl = this.configuration.isNewConfiguration() || this.configuration.isSsl();
        this.configuration.setSsl(Setup.getBooleanResponse(suppliedSsl));
        return this.configuration.isSsl();
    }

    private boolean askToGenerateKeys() {
        Setup.printEmptyLine();
        System.out.println("Would you like to generate a keystore with a self-signed certificate for you?");
        System.out.println("N.B.: Self-signed certificates do not work correctly with some versions of the Flash Player and some browsers!");
        System.out.println("Options are yes or no.");
        boolean suppliedGenerateKeys = this.configuration.isNewConfiguration() || this.generateKeyStore;
        this.generateKeyStore = Setup.getBooleanResponse(suppliedGenerateKeys);
        return this.generateKeyStore;
    }

    private void setDefaultKeyStoreSettings() {
        this.configuration.setKeyStorePath("conf/keystore.jks");
        this.configuration.setKeyStorePassword("storesecret");
        this.configuration.setKeyStoreKeyPassword("keysecret");
    }

    private void askKeyStoreSettings() {
        Setup.printEmptyLine();
        System.out.println("What is the path to the keystore?");
        String suppliedKeyStorePath = this.configuration.isNewConfiguration() ? "" : this.configuration.getKeyStorePath();
        this.configuration.setKeyStorePath(Setup.getStringResponse(suppliedKeyStorePath));
        Setup.printEmptyLine();
        System.out.println("What is the password to the keystore?");
        String suppliedKeyStorePassword = this.configuration.isNewConfiguration() ? "" : this.configuration.getKeyStorePassword();
        this.configuration.setKeyStorePassword(Setup.getStringResponse(suppliedKeyStorePassword));
        Setup.printEmptyLine();
        System.out.println("What is the password to the key in the keystore?");
        String suppliedKeyStoreKeyPassword = this.configuration.isNewConfiguration() ? "" : this.configuration.getKeyStoreKeyPassword();
        this.configuration.setKeyStoreKeyPassword(Setup.getStringResponse(suppliedKeyStoreKeyPassword));
    }

    private void askHttpBindAddressForJetty() {
        Setup.printEmptyLine();
        System.out.println("What http bind address would you like the server to listen on?");
        String defaultAddress = Strings.nullToEmpty((String)this.configuration.getHttpBindAddress()).isEmpty() ? "0.0.0.0" : this.configuration.getHttpBindAddress();
        this.configuration.setHttpBindAddress(Setup.getStringResponse(defaultAddress));
    }

    private void askHttpPortForJetty() {
        Setup.printEmptyLine();
        System.out.println("What http port number would you like the server to listen on?");
        int defaultPort = this.configuration.isSsl() ? 4517 : 4516;
        int suppliedPort = this.configuration.getHttpPort() == 0 ? defaultPort : this.configuration.getHttpPort();
        this.configuration.setHttpPort(Setup.getValidIntegerResponse(suppliedPort));
    }

    private void askImportablePackagesPath() {
        if (this.askImportablePackagesPath) {
            Setup.printEmptyLine();
            System.out.println("Where would you like " + this.serverName + " to import packages from?");
            String suppliedApplicationImportPath = this.configuration.getImportablePackagesPath() == null ? "importablePackages" : this.configuration.getImportablePackagesPath();
            this.configuration.setImportablePackagesPath(Setup.getValidNotEmptyStringResponse(suppliedApplicationImportPath));
        } else {
            this.configuration.setImportablePackagesPath("importablePackages");
        }
    }

    private boolean askDoYouWantToEditTheExistingConfiguration() {
        Setup.printEmptyLine();
        System.out.println("An existing " + this.serverName + " configuration was found. Do you want to edit it?");
        System.out.println("Options are yes or no. (selecting no will create an empty configuration)");
        boolean useOldConfig = Setup.getBooleanResponse(true);
        if (useOldConfig) {
            System.out.println("Editing the exisiting configuration.");
        } else {
            System.out.println("Starting configuration from scratch.");
        }
        return useOldConfig;
    }

    private void askJcrRepositoryPath() {
        Setup.printEmptyLine();
        System.out.println("Where would you like to store the JCR repository?");
        String path = this.configuration.getJcrRepositoryPath() == null ? "repository" : this.configuration.getJcrRepositoryPath();
        String userEnteredRepoPath = Setup.getValidNotEmptyStringResponse(path);
        this.configuration.setJcrRepositoryPath(Setup.convertAbsolutePathToFileUrlIfNeeded(userEnteredRepoPath));
    }

    private static String convertAbsolutePathToFileUrlIfNeeded(String path) {
        if (path.startsWith("/") || path.length() >= 3 && path.charAt(1) == ':' && path.charAt(2) == '\\') {
            return "file://" + path;
        }
        return path;
    }

    private boolean askToInitializeJcr() {
        Setup.printEmptyLine();
        System.out.println("Do you want to initialize the JCR repository?");
        System.out.println("Options are yes or no.");
        this.initializeJcrRepository = this.configuration.isNewConfiguration() ? Setup.getBooleanResponse(true) : Setup.getBooleanResponse(false);
        if (this.initializeJcrRepository) {
            System.out.println(this.serverName + " will initialize the JCR repository.");
            this.askToCreatePasswordEncryptionKey();
        } else {
            System.out.println(this.serverName + " will NOT initialize the JCR repository.");
        }
        return this.initializeJcrRepository;
    }

    private boolean askToCreatePasswordEncryptionKey() {
        Setup.printEmptyLine();
        System.out.println("The password encryption key protects the passwords stored in the repository. ");
        System.out.println("Do you want to generate a new password encryption key?");
        System.out.println("Options are yes or no.");
        this.generatePasswordEncryptionKey = Setup.getBooleanResponse(true);
        if (this.generatePasswordEncryptionKey) {
            System.out.println("The password encryption key is optionally secured by a password.");
            System.out.println("Please enter the password you wish to use. (Use an empty password to avoid a password prompt when starting " + this.serverName + ".)");
            this.passwordEncryptionKeyPassword = Setup.getConfirmedPassword();
        }
        return this.generatePasswordEncryptionKey;
    }

    private boolean reviewAndConfirm() {
        Setup.printEmptyLine();
        System.out.println("Do you agree with the following settings for " + this.serverName + " and would you like to save them?");
        System.out.println("Changes will be saved in " + this.serverConfigFile.getName());
        System.out.println("\tSSL will be " + (this.configuration.isSsl() ? "enabled" : "disabled"));
        if (this.configuration.isSsl()) {
            if (this.generateKeyStore) {
                System.out.println("\tKeystore will be generated");
            } else {
                System.out.println("\tKeystore path is " + this.configuration.getKeyStorePath());
                System.out.println("\tKeystore password is " + this.configuration.getKeyStorePassword());
                System.out.println("\tKeystore key password is " + this.configuration.getKeyStoreKeyPassword());
            }
        }
        System.out.println("\tHTTP bind address is " + this.configuration.getHttpBindAddress());
        System.out.println("\tHTTP port is " + this.configuration.getHttpPort());
        System.out.println("\tContext root is " + this.configuration.getWebContextRoot());
        if (this.askServerUrl) {
            System.out.println("\tPublic Server URL is " + this.configuration.getServerUrl());
        }
        System.out.println("\tHTTP server will use a minimum of " + this.configuration.getMinThreads() + " and a maximum of " + this.configuration.getMaxThreads() + " threads");
        try {
            System.out.println("\tJCR repository home is at " + this.resolveRepositoryHome().getFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.initializeJcrRepository) {
            System.out.println("\tJCR repository will be initialized.");
            System.out.println("\tTask recovery file will be deleted");
        }
        if (this.generatePasswordEncryptionKey) {
            System.out.println("\tPassword encryption key will be generated.");
        }
        if (this.askImportablePackagesPath) {
            System.out.println("\tApplication import location is " + this.configuration.getImportablePackagesPath());
        }
        return Setup.getBooleanResponse(true);
    }

    private void generateKeyStore() {
        String keyAlgorithm = "RSA";
        String keyStoreKeyAlias = "jetty";
        String dname = "CN=localhost,O=" + this.serverName + ",C=NL";
        try {
            int exitValue;
            File keyStoreFile = new File(this.configuration.getKeyStorePath());
            if (keyStoreFile.exists()) {
                System.out.println("Existing keystore " + this.configuration.getKeyStorePath() + " deleted.");
                keyStoreFile.delete();
            }
            System.out.println("Generating keystore...");
            String[] keytoolArgs = new String[]{"keytool", "-genkey", "-keyalg", keyAlgorithm, "-keystore", this.configuration.getKeyStorePath(), "-storepass", this.configuration.getKeyStorePassword(), "-alias", keyStoreKeyAlias, "-keypass", this.configuration.getKeyStoreKeyPassword(), "-validity", "366", "-dname", dname};
            Process p = Runtime.getRuntime().exec(keytoolArgs);
            Thread outputThread = new Thread(new InputStreamToOutputStream(p.getInputStream(), System.out));
            outputThread.start();
            Thread errorThread = new Thread(new InputStreamToOutputStream(p.getErrorStream(), System.err));
            errorThread.start();
            try {
                exitValue = p.waitFor();
            }
            catch (InterruptedException exc) {
                throw new IOException(exc.toString());
            }
            if (exitValue != 0) {
                throw new IOException("keytool exited with status code " + exitValue);
            }
            System.out.println("Keystore generated.");
        }
        catch (IOException exc) {
            System.err.println("WARNING: Could not generate keystore " + this.configuration.getKeyStorePath() + ": " + exc.toString());
        }
    }

    private void initializeJcrRepository() {
        Resource homeDirResource = this.resolveRepositoryHome();
        Setup.cleanUpAndReinitializeRepositoryHome(homeDirResource);
        JackrabbitRepositoryFactoryBean repositoryFactoryBean = new JackrabbitRepositoryFactoryBean();
        repositoryFactoryBean.setConfiguration((Resource)new ClassPathResource("jackrabbit-repository.xml"));
        repositoryFactoryBean.setHomeDir(homeDirResource);
        repositoryFactoryBean.setAutoInitialize(true);
        repositoryFactoryBean.setDeployitConfig(this.configuration);
        if (this.storeRepositoryIdWhenInitializingJcr) {
            repositoryFactoryBean.setRepositoryId(this.repositoryId);
        }
        try {
            repositoryFactoryBean.afterPropertiesSet();
        }
        catch (Exception exc) {
            throw new RuntimeException("Cannot initialize JCR repository", exc);
        }
        repositoryFactoryBean.destroy();
        System.out.println("JCR repository initialized.");
        Setup.deleteTaskRecoveryFile();
    }

    private Resource resolveRepositoryHome() {
        FileSystemResource homeDirResource;
        if (this.configuration.getJcrRepositoryPath().startsWith("file://")) {
            try {
                homeDirResource = new UrlResource(this.configuration.getJcrRepositoryPath());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("JCR Repository path is a malformed url. " + this.configuration.getJcrRepositoryPath());
            }
        } else {
            homeDirResource = new FileSystemResource(this.configuration.getJcrRepositoryPath());
        }
        return homeDirResource;
    }

    private static void cleanUpAndReinitializeRepositoryHome(Resource repoHomeResource) {
        File repositoryHome = null;
        try {
            repositoryHome = repoHomeResource.getFile();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Problem resolving absolute path to JCR repository at " + repoHomeResource.getFilename(), (Throwable)e);
        }
        if (repositoryHome.exists()) {
            System.out.println("Deleting JCR repository at " + repositoryHome);
            try {
                GuavaFiles.deleteRecursively((File)repositoryHome);
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot delete JCR repository at " + repositoryHome, (Throwable)exc);
            }
        }
        System.out.println("Creating JCR repository at " + repositoryHome);
        boolean created = repositoryHome.mkdirs();
        if (!created) {
            throw new RuntimeIOException("Unknown error occured while creating JCR repository at " + repoHomeResource);
        }
    }

    private static void deleteTaskRecoveryFile() {
        File taskRecoveryFile = new File("recovery.dat");
        if (taskRecoveryFile.exists()) {
            if (taskRecoveryFile.delete()) {
                System.out.println("Task recovery file deleted");
            } else {
                System.err.println("Couldn't delete the task recovery file");
            }
        }
    }

    private static void printEmptyLine() {
        System.out.println("");
    }

    private static String read() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = stdin.readLine();
            if (line != null) {
                String value = line.trim();
                if (EXITSETUP_KEYWORD.equals(value)) {
                    System.out.println("Exiting setup.");
                    System.exit(1);
                }
                return value;
            }
            return line;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean getBooleanResponse(boolean defaultValue) {
        String prompt = Setup.determinePrompt(defaultValue ? "yes" : "no");
        while (true) {
            System.out.print(prompt);
            String value = Setup.read();
            if ("".equals(value)) {
                return defaultValue;
            }
            if ("yes".equalsIgnoreCase(value)) {
                return true;
            }
            if ("no".equalsIgnoreCase(value)) {
                return false;
            }
            System.out.println("Illegal value specified, type yes or no.");
        }
    }

    private static String getValidNotEmptyStringResponse(String defaultValue) {
        String prompt = Setup.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = Setup.read();
            if ("".equals(value) && defaultValue != null) {
                value = defaultValue;
            }
            if (!"".equals(value) && value != null) {
                return value;
            }
            System.out.println("Value cannot be empty.");
        }
    }

    private static String getStringResponse(String defaultValue) {
        String value;
        String prompt = Setup.determinePrompt(defaultValue);
        do {
            System.out.print(prompt);
            value = Setup.read();
            if (!"".equals(value)) continue;
            value = defaultValue;
        } while (value == null);
        return value;
    }

    private static String getConfirmedPassword() {
        String password = null;
        while (true) {
            if (!(password = Setup.getPasswordResponse("New password: ")).isEmpty() && password.length() < 6) {
                System.err.println("Password is shorter than 6 characters, please try again.\n");
                continue;
            }
            String retypedPassword = Setup.getPasswordResponse("Re-type password: ");
            if (password.equals(retypedPassword)) {
                return password;
            }
            Setup.printEmptyLine();
            System.err.println("The passwords do not match. Please try again.");
        }
    }

    private static String getPasswordResponse(String prompt) {
        char[] password = System.console().readPassword(prompt, new Object[0]);
        return new String(password);
    }

    private static int getValidIntegerResponse(int defaultValueAsAnInt) {
        String defaultValue = Integer.toString(defaultValueAsAnInt);
        String prompt = Setup.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = Setup.read();
            if ("".equals(value)) {
                value = defaultValue;
            }
            try {
                int returnedValue = Integer.parseInt(value);
                if (returnedValue > 0) {
                    return returnedValue;
                }
                System.out.println("Illegal value specified. Number must be larger then 0.");
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Illegal value specified. Must be a number.");
                continue;
            }
            break;
        }
    }

    private static String determinePrompt(String defaultValue) {
        String prompt = defaultValue != null ? "[" + defaultValue + "]: " : ": ";
        return prompt;
    }

    public void setStoreRepositoryIdWhenInitializingJcr(boolean storeRepositoryIdWhenInitializingJcr) {
        this.storeRepositoryIdWhenInitializingJcr = storeRepositoryIdWhenInitializingJcr;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    private static class InputStreamToOutputStream
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public InputStreamToOutputStream(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                ByteStreams.copy((InputStream)this.in, (OutputStream)this.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

