package com.xebialabs.deployit.core.rest.json;

import ai.digital.deploy.sql.model.BannerInfo;
import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.core.rest.converters.BannerInfoJsonConverter;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class BannerInfoJsonReaderWriter implements MessageBodyWriter<BannerInfo>, MessageBodyReader<BannerInfo> {

    @Autowired
    public BannerInfoJsonReaderWriter() {
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return isReadable(type, genericType, annotations, mediaType);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return BannerInfo.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(final BannerInfo bannerInfo, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final BannerInfo bannerInfo, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(bannerInfo).getBytes());
    }

    @VisibleForTesting
    String toJson(final BannerInfo bannerInfo) {
        return getConverter().toJson(bannerInfo);
    }

    private BannerInfoJsonConverter getConverter() {
        return new BannerInfoJsonConverter();
    }


    @Override
    public BannerInfo readFrom(Class<BannerInfo> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String json = IOUtils.toString(entityStream, StandardCharsets.UTF_8);
        return getConverter().toBannerInfo(json);
    }
}
