package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import static com.xebialabs.deployit.checks.Checks.checkNotNull;
import static com.xebialabs.deployit.core.rest.api.DeploymentUtils.checkAndCast;

@Service
@Path("/internal/deployment")
@Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
public class DeploymentInternalResource extends AbstractSecuredResource {

    private static final Logger logger = LoggerFactory.getLogger(DeploymentInternalResource.class);

    @Autowired
    private RepositoryService repositoryService;

    @GET
    @Path("deployed/application")
    public ConfigurationItem getDeployedApplication(@QueryParam("application") String applicationId, @QueryParam("environment") String environmentId) {
        logger.trace("getDeployedApplication {}, {}", applicationId, environmentId);
        checkNotNull(applicationId, "application");
        checkNotNull(environmentId, "environment");
        Application application = checkAndCast(repositoryService.read(applicationId), Application.class);
        Environment environment = checkAndCast(repositoryService.read(environmentId), Environment.class);
        return repositoryService.read(IdGenerator.generateId(environment.getId(), application.getId()), 0);
    }

}
