package com.xebialabs.deployit.core.converters

import ai.digital.deploy.sql.model.ReportLine
import com.xebialabs.deployit.core.converters.ControlTaskReportLineField._
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine

import scala.collection.mutable
import scala.jdk.CollectionConverters._

object ControlTaskReportLineConverter {
  def toReportLine(line: ControlTaskReportLine): ReportLine = ReportLine.fromMap(mutable.Map(Map[String, Object](
    TASK_ID -> line.getTaskId,
    STARTED -> line.getStarted,
    FINISHED -> line.getFinished,
    STATE -> line.getState,
    OWNER -> line.getOwner,
    TASK_NAME -> line.getTaskName,
    CONTROL_TASK_TARGET_CI -> line.getControlTaskTargetCI,
    DESCRIPTION -> line.getDescription,
    WORKER_NAME -> line.getWorkerName
  ).toSeq: _*).asJava)
}

object ControlTaskReportLineField {
  val TASK_ID = "taskId"
  val STARTED = "started"
  val FINISHED = "finished"
  val STATE = "state"
  val OWNER = "owner"
  val TASK_NAME = "taskName"
  val CONTROL_TASK_TARGET_CI = "controlTaskTargetCI"
  val DESCRIPTION = "description"
  val WORKER_NAME = "worker_name"

  val allFields = Set(TASK_ID, STARTED, FINISHED, STATE, OWNER, TASK_NAME, CONTROL_TASK_TARGET_CI, DESCRIPTION, WORKER_NAME)
}
