/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.listener.version;

import com.xebialabs.deployit.core.events.CreateApplicationDeploymentPackage;
import com.xebialabs.deployit.core.events.DeleteApplicationDeploymentPackage;
import com.xebialabs.deployit.core.events.DeploymentPackageEvent;
import com.xebialabs.deployit.core.util.IdExtensions$;
import com.xebialabs.deployit.engine.api.dto.ApplicationDeploymentPackage;
import com.xebialabs.deployit.engine.api.dto.VersionTag;
import com.xebialabs.deployit.engine.spi.event.CiCopiedEvent;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.CisDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.listener.version.package$;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.xldeploy.status.queue.DeploymentPackageStatusStoreHolder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DeployitEventListener
@ScalaSignature(bytes="\u0006\u0005e4A!\u0003\u0006\u0001/!)a\u0005\u0001C\u0001O!)!\u0006\u0001C\u0001W!)Q\t\u0001C\u0001\r\")A\n\u0001C\u0001\u001b\")1\u000b\u0001C\u0001)\")!\f\u0001C\u00057\")Q\u000e\u0001C\u0005]\")\u0011\u000f\u0001C\u0005e\nQb+\u001a:tS>t\u0007K]8qC\u001e\fG/[8o\u0019&\u001cH/\u001a8fe*\u00111\u0002D\u0001\bm\u0016\u00148/[8o\u0015\tia\"\u0001\u0005mSN$XM\\3s\u0015\ty\u0001#\u0001\u0003d_J,'BA\t\u0013\u0003!!W\r\u001d7ps&$(BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!B:mMRR'\"A\u0012\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\n\u0011\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AC\u0001\u0012e\u0016\u001cW-\u001b<f\u0007&\u001c8I]3bi\u0016$GC\u0001\u00170!\tIR&\u0003\u0002/5\t!QK\\5u\u0011\u0015\u0001$\u00011\u00012\u0003\u0015)g/\u001a8u!\t\u0011\u0004(D\u00014\u0015\t\u0001DG\u0003\u00026m\u0005\u00191\u000f]5\u000b\u0005]\u0002\u0012AB3oO&tW-\u0003\u0002:g\ty1)[:De\u0016\fG/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0003wA\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\u0006iJ\u0012Wo\u001d\u0006\u0003\u0001\u0006\u000b\u0001B[1wC\u0012,H-\u001a\u0006\u0002\u0005\u0006\u0011a\u000e\\\u0005\u0003\tv\u0012\u0011bU;cg\u000e\u0014\u0018NY3\u0002!I,7-Z5wK\u000eK7oQ8qS\u0016$GC\u0001\u0017H\u0011\u0015\u00014\u00011\u0001I!\t\u0011\u0014*\u0003\u0002Kg\ti1)[\"pa&,G-\u0012<f]RD#aA\u001e\u0002#I,7-Z5wK\u000eK7\u000fR3mKR,G\r\u0006\u0002-\u001d\")\u0001\u0007\u0002a\u0001\u001fB\u0011!\u0007U\u0005\u0003#N\u0012qbQ5t\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\u0015\u0003\tm\n\u0001C]3dK&4XmQ5SK:\fW.\u001a3\u0015\u00051*\u0006\"\u0002\u0019\u0006\u0001\u00041\u0006C\u0001\u001aX\u0013\tA6G\u0001\bDSJ+g.Y7fI\u00163XM\u001c;)\u0005\u0015Y\u0014AI;qI\u0006$X-\u00119qY&\u001c\u0017\r^5p]\u0012+\u0007\u000f\\8z[\u0016tG\u000fU1dW\u0006<W\r\u0006\u0003-9&\\\u0007\"B/\u0007\u0001\u0004q\u0016aD1qa2L7-\u0019;j_:t\u0015-\\3\u0011\u0005}3gB\u00011e!\t\t'$D\u0001c\u0015\t\u0019g#\u0001\u0004=e>|GOP\u0005\u0003Kj\ta\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011QM\u0007\u0005\u0006U\u001a\u0001\rAX\u0001\u000b_2$g+\u001a:tS>t\u0007\"\u00027\u0007\u0001\u0004q\u0016A\u00038foZ+'o]5p]\u0006\u00113M]3bi\u0016\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8EKBdw._7f]R\u0004\u0016mY6bO\u0016$2\u0001L8q\u0011\u0015iv\u00011\u0001_\u0011\u0015aw\u00011\u0001_\u0003\t\"W\r\\3uK\u0006\u0003\b\u000f\\5dCRLwN\u001c#fa2|\u00170\\3oiB\u000b7m[1hKR\u0019Af\u001d;\t\u000buC\u0001\u0019\u00010\t\u000b)D\u0001\u0019\u00010)\u0005\u00011\bC\u0001\u001ax\u0013\tA8GA\u000bEKBdw._5u\u000bZ,g\u000e\u001e'jgR,g.\u001a:")
public class VersionPropagationListener
implements Logging {
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        VersionPropagationListener versionPropagationListener = this;
        synchronized (versionPropagationListener) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void receiveCisCreated(CisCreatedEvent event) {
        CollectionConverters$.MODULE$.ListHasAsScala(event.getCis()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            VersionPropagationListener.$anonfun$receiveCisCreated$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveCisCopied(CiCopiedEvent event) {
        ConfigurationItem configurationItem = event.getCi();
        if (configurationItem instanceof Version) {
            Version version = (Version)configurationItem;
            Application application = package$.MODULE$.readApplication(version);
            String oldVersion = IdExtensions$.MODULE$.idString(event.getEntity()).getName();
            String newVersion = IdExtensions$.MODULE$.idString(event.getNewId()).getName();
            this.updateApplicationDeploymentPackage(application.getName(), oldVersion, newVersion);
            return;
        }
    }

    @Subscribe
    public void receiveCisDeleted(CisDeletedEvent event) {
        CollectionConverters$.MODULE$.ListHasAsScala(event.getCis()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            VersionPropagationListener.$anonfun$receiveCisDeleted$1(this, event, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveCiRenamed(CiRenamedEvent event) {
        ConfigurationItem configurationItem = event.getCi();
        if (configurationItem instanceof Version) {
            Version version = (Version)configurationItem;
            Application application = package$.MODULE$.readApplication(version);
            String oldVersion = event.getCi().getName();
            String newVersion = event.getNewName();
            this.updateApplicationDeploymentPackage(application.getName(), oldVersion, newVersion);
            return;
        }
    }

    private void updateApplicationDeploymentPackage(String applicationName, String oldVersion, String newVersion) {
        this.deleteApplicationDeploymentPackage(applicationName, oldVersion);
        this.createApplicationDeploymentPackage(applicationName, newVersion);
    }

    private void createApplicationDeploymentPackage(String applicationName, String newVersion) {
        DeploymentPackageStatusStoreHolder$.MODULE$.getDeploymentPackageStatusStore().sendDeploymentPackageEvent((DeploymentPackageEvent)new CreateApplicationDeploymentPackage(new ApplicationDeploymentPackage(applicationName, new VersionTag(newVersion, ""))));
    }

    private void deleteApplicationDeploymentPackage(String applicationName, String oldVersion) {
        DeploymentPackageStatusStoreHolder$.MODULE$.getDeploymentPackageStatusStore().sendDeploymentPackageEvent((DeploymentPackageEvent)new DeleteApplicationDeploymentPackage(new ApplicationDeploymentPackage(applicationName, new VersionTag(oldVersion, ""))));
    }

    public static final /* synthetic */ void $anonfun$receiveCisCreated$1(VersionPropagationListener $this, ConfigurationItem x0$1) {
        ConfigurationItem configurationItem = x0$1;
        if (configurationItem instanceof Version) {
            Version version = (Version)configurationItem;
            Application application = package$.MODULE$.readApplication(version);
            $this.createApplicationDeploymentPackage(application.getName(), version.getVersion());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$receiveCisDeleted$2(Version x2$1, ConfigurationItem ci) {
        return x2$1.getId().startsWith(ci.getId());
    }

    public static final /* synthetic */ void $anonfun$receiveCisDeleted$1(VersionPropagationListener $this, CisDeletedEvent event$1, ConfigurationItem x0$1) {
        ConfigurationItem configurationItem = x0$1;
        if (configurationItem instanceof Version) {
            Application application;
            Version version = (Version)configurationItem;
            try {
                application = package$.MODULE$.readApplication(version);
            }
            catch (NotFoundException e) {
                application = (ConfigurationItem)CollectionConverters$.MODULE$.ListHasAsScala(event$1.getCis()).asScala().find((Function1 & Serializable)ci -> BoxesRunTime.boxToBoolean((boolean)VersionPropagationListener.$anonfun$receiveCisDeleted$2(version, ci))).getOrElse((Function0 & Serializable)() -> {
                    throw e;
                });
            }
            catch (Throwable e) {
                throw e;
            }
            Application application2 = application;
            $this.deleteApplicationDeploymentPackage(application2.getName(), version.getVersion());
            return;
        }
    }

    public VersionPropagationListener() {
        Logging.$init$((Logging)this);
    }
}

