package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.core.common.security.permission.DeployitPermissions;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import com.xebialabs.deployit.service.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.xebialabs.deployit.core.rest.resteasy.Workdir.Clean.ONLY_ON_EXCEPTION;
import static com.xebialabs.deployit.repository.WorkDirFactory.TASK_WORKDIR_PREFIX;

@Service
public class ControlTaskResource extends AbstractSecuredResource implements ControlService {
    @Autowired
    private ControlTaskService controlTaskService;

    @Autowired
    private Validator validator;

    @Override
    public Control prepare(String controlName, String id) {
        checkPermission(DeployitPermissions.CONTROLTASK_EXECUTE(), id);
        return controlTaskService.prepare(controlName, id);
    }

    @Override
    @Workdir(prefix = TASK_WORKDIR_PREFIX, clean = ONLY_ON_EXCEPTION)
    public String createTask(final Control control) {
        checkPermission(DeployitPermissions.CONTROLTASK_EXECUTE(), control.getConfigurationItem().getId());
        validate(control);
        return controlTaskService.create(control, Permissions.getAuthentication(), WorkdirHolder.get());
    }

    private void validate(final Control control) {
        if (control.getParameters() != null) {
            validator.validateCi(control.getParameters());
        }
    }
}
