package com.xebialabs.deployit.core.rest.json

import com.xebialabs.deployit.core.events.CiRef
import com.xebialabs.xltype.serialization.json.JsonWriter
import org.springframework.stereotype.Component

import java.io.{OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyWriter, Provider}
import jakarta.ws.rs.{Consumes, Produces}

@Component
@Provider
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
class CiRefsJsonWriter extends MessageBodyWriter[util.Collection[CiRef]] {

  private val helper = new JsonWriterHelper

  override def isWriteable(`type`: Class[_],
                           genericType: Type,
                           annotations: Array[Annotation],
                           mediaType: MediaType): Boolean =
    classOf[CiRef].isAssignableFrom(helper.getType(`type`, genericType))

  override def getSize(ciRefs: util.Collection[CiRef],
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  override def writeTo(ciRefs: util.Collection[CiRef],
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    val streamWriter: OutputStreamWriter = new OutputStreamWriter(entityStream)
    writeJson(ciRefs, new JsonWriter(streamWriter))
    streamWriter.flush()
  }

  private def writeJson(ciRefs: util.Collection[CiRef], writer: JsonWriter): Unit = {
    writer.array
    ciRefs.forEach(ref => {
      writer.`object`()
      writer.key("ref").value(ref.id)
      writer.key("type").value(ref.`type`)
      writer.key("version").value(ref.version)
      writer.endObject()
    })
    writer.endArray
  }
}
