/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DeploymentUtils;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Path(value="/internal/deployment")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public class DeploymentInternalResource
extends AbstractSecuredResource {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentInternalResource.class);
    @Autowired
    private RepositoryService repositoryService;

    @GET
    @Path(value="deployed/application")
    public ConfigurationItem getDeployedApplication(@QueryParam(value="application") String applicationId, @QueryParam(value="environment") String environmentId) {
        logger.trace("getDeployedApplication {}, {}", (Object)applicationId, (Object)environmentId);
        Checks.checkNotNull((Object)applicationId, (String)"application");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        Application application = DeploymentUtils.checkAndCast(this.repositoryService.read(applicationId), Application.class);
        Environment environment = DeploymentUtils.checkAndCast(this.repositoryService.read(environmentId), Environment.class);
        return this.repositoryService.read(IdGenerator.generateId((String)environment.getId(), (String)application.getId()), 0);
    }
}

